#!/bin/sh

#
# NAME
#	install.sh
#
# SYNOPSIS
#	install.sh temp_file_to_install actual_file_name
#
#	where
#		temp_file_to_install shoud be either:
#		-	an .RPM formated file that should be installed
#			by calling the HTTP #	API package/load?install=true
#
#		-	A .TAR formatted file that should be installed by
#			untar'ing the contents and running the embedded
#			packageInstall.sh script that is included as part
#			of the .TAR
#
#		actual_file_name is
#		-	The actual name of the file that was uploaded
#			and not the mangled / random guaranteed name
#			that the web server has given to the uploaded file
#	
# DESCRIPTION
#	This utility is included as part of th SDK package.  It contains
#	a unified method of installing new packages and updated packages
#	through the SDK main web page /home/sdk/htmlindex.html page.
#
#	At the bottom of the SDK main web page is a clickable button that
#	allows the developer to select an installation file which may be
#	an Equinox prepared (future signed) .RPM format file that contains
#	embedded installation scripts, or a VAR developer prepared .TAR
#	format file that contains a named file "packageInstall.sh" in
#	addition to the files to be installed.
#
# RETURNS
#	This utility should put the return message into a file with the same
#	name as the file to install with an extra suffix of .res added.
#
# VERSION
#	1.1	2016-08-15	Initial version that supports both .RPM
#				and .TAR format upgrade files.
#
#	1.2	2016-11-10	Use package/install instead of package/load?install=true
#				as I already have the file and I don't need to load it
#				from one directory to another.  Just move it then
#				install it.

#
# If the file extension is .gz then
#   unzip the file into /home/sdk/files
#   call myself with the name of the unzipped file
# end if
#
# If file etension is .tar then
#   process a .tar file
#   Update result in /tmp/name.tar.gz.res
#
# else if the extension is .rpm then
#   process a .rpm file
# else
#   set .res file to "unknown file type"
# end if
#

LOG="/tmp/sdk_update.log"
BASE="/home/sdk/temp/"
mkdir -p $BASE

cleanup () {
   cd $BASE && rm -rf * &> /dev/null
   sync
}

#
# Start here
# ==========
#
echo "install V1.2: ---------- START ---------- " >> $LOG
rm /tmp/*.res &> /dev/null
rm -f $BASE/* &> /dev/null


RES_FILE="${1}.res"
echo "install: RES_FILE is $RES_FILE" >>$LOG
REALFILENAME=$2

if [ -s $1 ]
then
  echo "install: $1 ($2) is valid, non-zero file " >> $LOG
else
  echo "install: $1 ($2) is zero-size or does not exists. Abort [6]." >> $LOG
  echo "Abort 6 : $1 is zero-size or does not exists." > $RES_FILE
  return
fi

cd $BASE
mv $1 $REALFILENAME

#
# Put the response back into a file using the temporary filename.res
#
TMP_FILE=`basename $1`

EXTENSION="${REALFILENAME##*.}"
echo "file extension is $EXTENSION" >> $LOG
if [ $EXTENSION = gz ] ; then
  echo "Note: $ARCH_PATH ($2) is a compressed .gz file" > $RES_FILE
  echo "install:  $ARCH_PATH ($2) is a .gz compressed file" >> $LOG
  #
  # unzip to $BASE directory and drop down to process the file
  #
  echo "gunzip $REALFILENAME" >> $LOG
  gunzip $REALFILENAME
  REALFILENAME="${REALFILENAME%.*}"
fi
echo "install: I need to process file $REALFILENAME in /home/sdk/temp" >> $LOG
EXTENSION="${REALFILENAME##*.}"
echo "install: File extension is .$EXTENSION" >>$LOG

if [ $EXTENSION = tar ] ; then
  #
  # Process a .tar file
  #
  #   .TAR PACKAGE FILE FORMAT
  #   ========================
  #   name.tar.gz  (web path is /tmp/name.tar.gz) (usb path is /mnt/usbstick/*/name.tar.gz)
  #      |
  #      +---- packageInstall.sh
  #      |
  #      +---- data_files... # packageInstall.sh knows how to deal with this
  #
  echo "install: Processing a .tar file" >>$LOG
  echo "install: Unpacking $ARCH_FILE " >> $LOG
  tar xvf $REALFILENAME &> /dev/null
  if [ $? -ne 0 ]
  then
    echo "install: error decompressing archive $REALFILENAME Abort [1]." >> $LOG
    echo "Abort 1 : File $REALFILENAME doesn't appear to be a valid update .tar file" > $RES_FILE
    sync
    cleanup
    return
  fi
  rm -f ./$REALFILENAME
  #
  # Must have packageInstall.sh
  #
  if [ ! -s ./packageInstall.sh ] ; then
    echo "install:  missing packageInstall.sh.  Abort [2]" >> $LOG
    echo "Abort 2 : File $REALFILENAME is missing ithe file packageInstall.sh" > $RES_FILE
    cleanup
    return
  fi
  #
  # run the install script
  #
  chmod +x ./packageInstall.sh &> /dev/null
  echo "install: executing packageInstall.sh " >> $LOG
  ls -al >>$LOG
  ./packageInstall.sh $LOG
  RES=$?
  if [ $RES -eq 0 ] ; then
    echo "install: packageInstall.sh reported no errors." >> $LOG
    echo "OK : No errors." > $RES_FILE
  else
    echo "install: packageInstall.sh error. Abort [3]" >> $LOG
    echo "Abort 3 : packageInstall.sh ERROR" > $RES_FILE
  fi
  cleanup
  return

elif [ $EXTENSION = rpm ] ; then
  #
  # Process a .rpm file
  # ===================
  #
  # Move it from the $BASE directory to the /var/lib/installer/to_update
  # directory to avoid calling the package/load to put the file there.
  #
  #
  echo "install: Processing a .rpm file" >>$LOG
  sync
  mv $REALFILENAME /var/lib/installer/to_update
  chmod a+r /var/lib/installer/to_update/$REALFILENAME
  ls -al /var/lib/installer/to_update >>$LOG
  echo "$REALFILENAME moved to /var/lib/installer/to_update" >>$LOG
  echo "curl \"http://127.0.0.1/cgi-bin/package/install?fileName=$REALFILENAME\" " >>$LOG
  sync
  curl "http://127.0.0.1/cgi-bin/package/install?fileName=$REALFILENAME"
#  cleanup
  return
else
  #
  # Unknown file type.
  #
  echo "Abort 1 : File $REALFILENAME extension .$EXTENSION is not a valid file type" >$RES_FILE
  echo "install: Unknown file type .$EXTENSION" >>$LOG
  exit
fi

