(function ($) {
    window.descriptor = window.descriptor || {};

    window.descriptor = {
        load: function (path, cb) {
            descriptorPrivate.load(path, cb);
        },

        next: function (cb) {
            descriptorPrivate.next(cb);
        },

        previous: function (cb) {
            descriptorPrivate.previous(cb);
        },

        back: function (cb) {
            descriptorPrivate.back(cb);
        },

        pageCount: function () {
            return descriptorPrivate.pageCount();
        }
    };

    // implementation
    var descriptorPrivate = {
        menuItems: null,
        page: 0,
        itemsPerPage: 5
    };

    descriptorPrivate.pageCount = function () {
        if (!descriptorPrivate.menuItems) {
            return 0;
        }

        return Math.ceil(descriptorPrivate.menuItems.length / descriptorPrivate.itemsPerPage);
    };

    function MenuItem(item) {
        this.target = "";
        this.title = "";
        this.icon = "";
        this.icon_position = "";
        this.optional = "";

        if (!item || typeof item !== 'object') {
            console.log('invalid menu item: ' + item);
            return;
        }

        for (var property in item) {
            if (Object.prototype.hasOwnProperty.call(this, property)) {
                this[property] = item[property];
            }
        }

        if (item.target_griffin && settings.is6200()) {
            this.target = item.target_griffin;
        }
    }

    MenuItem.prototype.optionalEnabled = function (obj) {
        if (obj.title == "Flashlight") {
            return tools.flAvailable() == 1;
        }

        if (obj.optional != "") {
            var val = registry.getValue(obj.optional);
            if (val != null) {
                return "1" == val;
            }
        }
        return true;
    };

    descriptorPrivate.load = function (path, cb) {
        $.get(path, function (data) {
            descriptorPrivate.menuItems = [];
            descriptorPrivate.page = 0;
            var optionalKeys = [];
            for (var i in data) {
                var item = new MenuItem(data[i]);
                if (item.optionalEnabled(item)) {
                    descriptorPrivate.menuItems.push(item);
                }
                if (item.optional) {
                    optionalKeys.push(item.optional);
                }
            }
            descriptorPrivate.menuItems
                .sort(function (a, b) {
                    return a.icon_position - b.icon_position;
                });

            cb(descriptorPrivate.menuItems.slice(0, descriptorPrivate.itemsPerPage), optionalKeys);

        }, "json")
            .fail(function (jqXHR, textStatus, errorThrown) {
                console.log("failed to load menu items, status: '" + textStatus + "'");
            });
    };

    descriptorPrivate.next = function (cb) {
        descriptorPrivate.page++;
        if (descriptorPrivate.page > descriptorPrivate.pageCount() - 1) {
            descriptorPrivate.page = 0;
        }

        var start = descriptorPrivate.itemsPerPage * descriptorPrivate.page;
        cb(descriptorPrivate.menuItems.slice(
            start,
            start + descriptorPrivate.itemsPerPage));
    };

    descriptorPrivate.previous = function (cb) {
        descriptorPrivate.page--;
        if (descriptorPrivate.page < 0) {
            descriptorPrivate.page = descriptorPrivate.pageCount() - 1;
        }

        var start = descriptorPrivate.itemsPerPage * descriptorPrivate.page;
        cb(descriptorPrivate.menuItems.slice(
            start,
            start + descriptorPrivate.itemsPerPage));
    };

    descriptorPrivate.back = function (cb) {
        descriptorPrivate.page--;
        if (descriptorPrivate.page < 0) {
            descriptorPrivate.page = 0;
        }

        var start = descriptorPrivate.itemsPerPage * descriptorPrivate.page;
        cb(descriptorPrivate.menuItems.slice(
            start,
            start + descriptorPrivate.itemsPerPage));
    };
})($);
