#!/bin/sh
#===============================================================================
#  Company:
#      Equinox Payments, LLC
#
#  Product:
#      MPlayer
#      Copyright 2011-2022 Equinox Payments, LLC
#
#  \brief
#      WakeLock script for mplayer
#
#===============================================================================
# Check if already running. Do not start a new instance
mypid=`pgrep -f /usr/bin/mplayer_wakelock.sh`
if [[ "$mypid" != "$$" ]]; then
    exit 0;
fi

mplayer_running=0
for i in `pidof mplayer`; do
    mplayer_full=`readlink /proc/$i/exe`
    if [[ "$mplayer_full" == "/usr/bin/mplayer" ]]; then
         mplayer_running=1
         break
    fi
done

if [[ $mplayer_running == 1 ]]; then
    dbus-send --system --type=method_call --print-reply --dest=com.equinoxpayments.powermanager / com.equinoxpayments.powermanager.Server.WakeLock int32:1 &>/dev/null
fi
