//==============================================================================
//  Company:
//      Equinox Payments, LLC
//
//  Product:
//      Android Pay plugin for NFC arbitrator
//      Copyright 2011-2023 Equinox Payments, LLC
//
//  \brief
//      Android Pay plugin for NFC arbitrator
//
//==============================================================================

#pragma once

enum class AndroidPayPluginErrorCode
{
    // SelectMobileWallet error codes
    SMW_ResponseLengthIsTooShort = 0x0101, //!< Response length is too short
    SMW_FailedToGetTagC0 = 0x0102, //!< Failed to get tag C0
    SMW_FailedToGetTagC1 = 0x0103, //!< Failed to get tag C1
    SMW_FailedToGetTagBF0C = 0x0104, //!< Failed to get tag BF0C
    SMW_FailedToGetTagA5 = 0x0105, //!< Failed to get tag A5
    SMW_PossiblyTransientFailure = 0x0106, //!< Possibly transient failure
    SMW_UnknownTerminalData = 0x0107, //!< Unknown terminal data
    SMW_CustomerActionRequired = 0x0108, //!< Customer action required
    SMW_FailedToPushApplicationVersionC0 = 0x0109, //!< Failed to push application version C0
    SMW_UnsupportedVersionDF6D = 0x010A, //!< Unsupported version DF6D
    SMW_UnsupportedVersionDF4D = 0x010B, //!< Unsupported version DF4D

    // SelectSmartTap error codes
    SST_ResponseIsTooShort1 = 0x0201, //!< Response is too short
    SST_ResponseIsTooShort2 = 0x0202, //!< Response is too short
    SST_UnsupportedMinVersion = 0x0203, //!< Unsupported version
    SST_UnsupportedMaxVersion = 0x0204, //!< Unsupported version
    SST_AbortTransaction = 0x0205, //!< Abort transaction
    SST_PossiblyTransientFailure = 0x0206, //!< Possibly transient failure
    SST_UnknownTerminalData = 0x0207, //!< Unknown terminal data
    SST_CustomerActionRequired = 0x0208, //!< Customer action required
    SST_UnexpectedSWValue = 0x0209, //!< Unexpected SW value

    // NegotiateSmartTapSecureSession error codes
    NSTSS_CryptoIsNotReady = 0x0301, //!< Crypto is not ready
    NSTSS_ResponseIsTooShort = 0x0302, //!< Response  is too short
    NSTSS_AbortTransaction = 0x0303, //!< Abort transaction
    NSTSS_PossiblyTransientFailure = 0x0304, //!< Possibly transient failure
    NSTSS_UnknownTerminalData = 0x0305, //!< Unknown terminal data
    NSTSS_CustomerActionRequired = 0x0306, //!< Customer action required
    NSTSS_UnexpectedSWValue = 0x0307, //!< Unexpected SW value
    NSTSS_SesPayloadIsTooShort = 0x0308, //!< Ses payload is too short
    NSTSS_WrongSessionID = 0x0309, //!< Wrong session ID

    // GetSmartTapData error codes
    GSTD_ResponseIsTooShort = 0x0401, //!< Response  is too short
    GSTD_AbortTransaction = 0x0402, //!< Abort transaction
    GSTD_PossiblyTransientFailure = 0x0403, //!< Possibly transient failure
    GSTD_UnknownTerminalData = 0x0404, //!< Unknown terminal data
    GSTD_CustomerActionRequired = 0x0405, //!< Customer action required
    GSTD_UnexpectedSWValue = 0x0406, //!< Unexpected SW value
    GSTD_ParseNDEFRecordsSesShort = 0x0407,   //!< Ses payload is too short
    GSTD_ParseNDEFRecordsWrongSessionId = 0x0408, //!< Wrong session ID

    // PushSmartTapData error codes
    PSTD_ResponseIsTooShort = 0x0501, //!< Response  is too short
    PSTD_AbortTransaction = 0x0502, //!< Abort transaction
    PSTD_PossiblyTransientFailure = 0x0503, //!< Possibly transient failure
    PSTD_UnknownTerminalData = 0x0504, //!< Unknown terminal data
    PSTD_CustomerActionRequired = 0x0505, //!< Customer action required
    PSTD_UnexpectedSWValue = 0x0506, //!< Unexpected SW value

    // Encryptor error codes
    E_InvalidPublicKeySize = 0x0601, //!< Invalid public key size. Expected 59
    E_InvalidPrivateClearKeySize = 0x0602, //!< Invalid private clear key size. Expected 121
    E_InvalidEphemeralKeySize = 0x0603, //!< Invalid ephemeral key size. Expected 33
    E_SignDataClearPrivateFailed1 = 0x0604, //!< EVP_MD_CTX_create() failed (nullptr) in function SignDataClearPrivate
    E_SignDataClearPrivateFailed2 = 0x0605, //!< BN_bin2bn() failed (nullptr) in function SignDataClearPrivate
    E_SignDataClearPrivateFailed3 = 0x0606, //!< OSSL_PARAM_BLD_new() failed (nullptr) in function SignDataClearPrivate
    E_SignDataClearPrivateFailed4 = 0x0607, //!< OSSL_PARAM_BLD_push_utf8_string() failed in function SignDataClearPrivate
    E_SignDataClearPrivateFailed5 = 0x0608, //!< OSSL_PARAM_BLD_push_BN() failed in function SignDataClearPrivate
    E_SignDataClearPrivateFailed6 = 0x0609, //!< OSSL_PARAM_BLD_to_param() failed (nullptr) in function SignDataClearPrivate
    E_SignDataClearPrivateFailed7 = 0x060A, //!< EVP_PKEY_CTX_new_from_name() failed (nullptr) in function SignDataClearPrivate
    E_SignDataClearPrivateFailed8 = 0x060B, //!< EVP_PKEY_fromdata_init() failed in function SignDataClearPrivate
    E_SignDataClearPrivateFailed9 = 0x060C, //!< EVP_PKEY_fromdata_init() failed in function SignDataClearPrivate
    E_SignDataClearPrivateFailed10 = 0x060D, //!< EC_KEY_set_private_key() failed in function SignDataClearPrivate
    E_SignDataClearPrivateFailed11 = 0x060E, //!< EVP_DigestSignUpdate() failed in function SignDataClearPrivate
    E_SignDataClearPrivateFailed12 = 0x060F, //!< EVP_DigestSignFinal() failed in function SignDataClearPrivate
    E_DecryptFailed1 = 0x0613, //!< EC_GROUP_new_by_curve_name() failed in function Decrypt
    E_DecryptFailed2 = 0x0614, //!< BN_CTX_new() failed in function Decrypt
    E_DecryptFailed3 = 0x0615, //!< EC_POINT_new() failed in function Decrypt
    E_DecryptFailed4 = 0x0616, //!< EC_POINT_oct2point() failed in function Decrypt
    E_EncryptFailed1 = 0x0620, //!< EVP_EC_gen() failed in function Encrypt
    E_EncryptFailed2 = 0x0621, //!< EC_GROUP_new_by_curve_name() failed in function Encrypt
    E_EncryptFailed3 = 0x0622, //!< EVP_PKEY_get_bn_param() failed in function Encrypt
    E_EncryptFailed4 = 0x0623, //!< EVP_PKEY_get_octet_string_param() failed in function Encrypt
    E_EncryptFailed5 = 0x0624, //!< EC_POINT_new() failed in function Encrypt
    E_EncryptFailed6 = 0x0625, //!< EC_POINT_oct2point() failed in function Encrypt
    E_EncryptFailed7 = 0x0626, //!< BN_CTX_new() failed in function Encrypt
    E_EncryptFailed8 = 0x0627, //!< EC_POINT_new() failed in function Encrypt
    E_EncryptFailed9 = 0x0628, //!< Unexpected terminal key size in function Encrypt
    E_EncryptFailed10 = 0x0629, //!< EC_POINT_oct2point() failed in function Encrypt
    E_EncryptFailed11 = 0x062A, //!< EC_POINT_point2oct() failed in function Encrypt
    E_HKDFwithSHA256_expandFailed1 = 0x0630, //!< EVP_MAC_fetch() failed in function HKDFwithSHA256_expand
    E_HKDFwithSHA256_expandFailed2 = 0x0631, //!< EVP_MAC_CTX_new() failed in function HKDFwithSHA256_expand
    E_HKDFwithSHA256_expandFailed3 = 0x0632, //!< EVP_MAC_init() failed in function HKDFwithSHA256_expand
    E_HKDFwithSHA256_expandFailed4 = 0x0633, //!< EVP_MAC_update() failed in function HKDFwithSHA256_expand
    E_HKDFwithSHA256_expandFailed5 = 0x0634, //!< EVP_MAC_update()/a failed in function HKDFwithSHA256_expand
    E_HKDFwithSHA256_expandFailed6 = 0x0635, //!< EVP_MAC_update()/b failed in function HKDFwithSHA256_expand
    E_HKDFwithSHA256_expandFailed7 = 0x0636, //!< EVP_MAC_final() failed in function HKDFwithSHA256_expand
    E_generateHmacFailed1 = 0x0637, //!< EVP_MAC_fetch() failed in function generateHmac
    E_generateHmacFailed2 = 0x0638, //!< EVP_MAC_CTX_new() failed in function generateHmac
    E_generateHmacFailed3 = 0x0639, //!< EVP_MAC_init() failed in function generateHmac
    E_generateHmacFailed4 = 0x063A, //!< HMAC_Update() failed in function generateHmac
    E_generateHmacFailed5 = 0x063B, //!< EVP_MAC_final() failed in function generateHmac
    E_HMACFailed = 0x0647, //!< HMAC() failed
    E_aesEncryptFailed1 = 0x0650, //!< EVP_CIPHER_CTX_new() failed in function aesEncrypt
    E_aesEncryptFailed2 = 0x0651, //!< EVP_EncryptInit_ex() failed in function aesEncrypt
    E_aesEncryptFailed3 = 0x0652, //!< EVP_EncryptUpdate() failed in function aesEncrypt
    E_aesEncryptFailed4 = 0x0653, //!< EVP_EncryptFinal() failed in function aesEncrypt
    E_aesDecryptFailed1 = 0x0654, //!< EVP_CIPHER_CTX_new() failed in function aesDecrypt
    E_aesDecryptFailed2 = 0x0655, //!< EVP_DecryptInit_ex() failed in function aesDecrypt
    E_aesDecryptFailed3 = 0x0656, //!< EVP_DecryptUpdate() failed in function aesDecrypt
    E_aesDecryptFailed4 = 0x0657, //!< EVP_DecryptFinal() failed in function aesDecrypt
    E_CheckIfKeyIdExistsFailed1 = 0x0663, //!< Failed to open vsec0
    E_CheckIfKeyIdExistsFailed2 = 0x0664, //!< CheckIfKeyIdExists() failed
    E_CheckIfKeyIdExistsFailed3 = 0x0665, //!< Can't find key with given id
    E_InvalidPrivateKeySize = 0x0666, //!< Invalid private key size. Expected 32
    E_SignDataPrivateFailed1 = 0x0670, //!< Failed to open vrki0 for data signing in function SignDataPrivate
    E_SignDataPrivateFailed2 = 0x0671, //!< Key size is not valid in function SignDataPrivate
    E_SignDataPrivateFailed3 = 0x0672, //!< ioctl failed in function SignDataPrivate
    E_SignDataPrivateFailed4 = 0x0673, //!< select failed in function SignDataPrivate
    E_SignDataPrivateFailed5 = 0x0674, //!< read failed in function SignDataPrivate
    E_GenerateKeysFailed1 = 0x0680, //!< EVP_EC_gen() failed in function GenerateKeys
    E_GenerateKeysFailed2 = 0x0681, //!< EC_GROUP_new_by_curve_name() failed in function GenerateKeys
    E_GenerateKeysFailed3 = 0x0682, //!< EC_KEY_get0_private_key() failed in function GenerateKeys
    E_GenerateKeysFailed4 = 0x0683, //!< BN_CTX_new() failed in function GenerateKeys
    E_GenerateKeysFailed5 = 0x0684, //!< EVP_PKEY_get_octet_string_param() failed in function GenerateKeys
    E_GenerateKeysFailed6 = 0x0685, //!< EC_POINT_oct2point() failed in function GenerateKeys
    E_GenerateKeysFailed7 = 0x0686, //!< EC_POINT_point2oct() failed in function GenerateKeys
    E_VerifySignatureFailed1 = 0x0690, //!< EVP_MD_CTX_create() failed in function VerifySignature
    E_VerifySignatureFailed2 = 0x0691, //!< OSSL_PARAM_BLD_new() failed (nullptr) in function VerifySignature
    E_VerifySignatureFailed3 = 0x0692, //!< OSSL_PARAM_BLD_push_utf8_string() failed in function VerifySignature
    E_VerifySignatureFailed4 = 0x0693, //!< OSSL_PARAM_BLD_push_octet_string() failed in function VerifySignature
    E_VerifySignatureFailed5 = 0x0694, //!< OSSL_PARAM_BLD_to_param() failed (nullptr) in function VerifySignature
    E_VerifySignatureFailed6 = 0x0695, //!< EVP_PKEY_CTX_new_from_name() failed (nullptr) in function VerifySignature
    E_VerifySignatureFailed7 = 0x0696, //!< EVP_PKEY_fromdata_init() failed in function VerifySignature
    E_VerifySignatureFailed8 = 0x069A, //!< EVP_PKEY_fromdata() failed in function VerifySignature
    E_VerifySignatureFailed9 = 0x069B, //!< EVP_DigestVerifyInit() failed in function VerifySignature
    E_VerifySignatureFailed10 = 0x069C, //!< EVP_DigestVerifyUpdate() failed in function VerifySignature
    E_EcdhFailed1 = 0x06A0, //!< OSSL_PARAM_BLD_new() failed (nullptr) in function Ecdh
    E_EcdhFailed2 = 0x06A1, //!< OSSL_PARAM_BLD_push_utf8_string() failed in function Ecdh
    E_EcdhFailed3 = 0x06A2, //!< OSSL_PARAM_BLD_push_BN() failed in function Ecdh
    E_EcdhFailed4 = 0x06A3, //!< OSSL_PARAM_BLD_to_param() failed (nullptr) in function Ecdh
    E_EcdhFailed5 = 0x06A4, //!< EVP_PKEY_CTX_new_from_name() failed (nullptr) in function Ecdh
    E_EcdhFailed6 = 0x06A5, //!< EVP_PKEY_fromdata_init() failed in function Ecdh
    E_EcdhFailed7 = 0x06A6, //!< EVP_PKEY_fromdata_init() failed in function Ecdh
    E_EcdhFailed8 = 0x06A7, //!< EC_GROUP_new_by_curve_name() failed (nullptr) in function Ecdh
    E_EcdhFailed9 = 0x06A8, //!< EC_POINT_point2oct() failed in function Ecdh
    E_EcdhFailed10 = 0x06A9, //!< OSSL_PARAM_BLD_new() failed (nullptr) in function Ecdh
    E_EcdhFailed11 = 0x06AA, //!< OSSL_PARAM_BLD_push_utf8_string() failed in function Ecdh
    E_EcdhFailed12 = 0x06AB, //!< OSSL_PARAM_BLD_push_BN() failed in function Ecdh
    E_EcdhFailed13 = 0x06AC, //!< OSSL_PARAM_BLD_to_param() failed (nullptr) in function Ecdh
    E_EcdhFailed14 = 0x06AD, //!< EVP_PKEY_fromdata_init() failed in function Ecdh
    E_EcdhFailed15 = 0x06AE, //!< EVP_PKEY_CTX_new() failed in function Ecdh
    E_EcdhFailed16 = 0x06AF, //!< EVP_PKEY_derive_init() failed in function Ecdh
    E_EcdhFailed17 = 0x06B0, //!< EVP_PKEY_derive_set_peer() failed in function Ecdh
    E_EcdhFailed18 = 0x06B1, //!< EVP_PKEY_derive_set_peer() failed in function Ecdh
    E_EcdhFailed19 = 0x06B2, //!< EVP_PKEY_derive() failed in function Ecdh

    GenRandomFailed = 0x0801, //!< Failed to generate random numbers

    Failed = -1, //!< General failed
    SendCommandFailed = -2, //!< Send command failed
};
