(function ($) {
    window.descriptor = window.descriptor || {};
    var descriptorPrivate = {};

    window.descriptor = {
        load: function (path, cb, doneCb) {
            descriptorPrivate.load(path, cb, doneCb);
        },

        next: function (cb) {
            descriptorPrivate.next(cb);
        },

        previous: function (cb) {
            descriptorPrivate.previous(cb);
        },

        back: function (cb) {
            descriptorPrivate.back(cb);
        },

        pageCount: function () {
            return descriptorPrivate.pageCount();
        }
    };

    // implementation
    descriptorPrivate = {
        menuItems: null,
        page: 0,
        itemsPerPage: 5
    };

    descriptorPrivate.pageCount = function () {
        if (!descriptorPrivate.menuItems) {
            return 0;
        }

        return Math.ceil(descriptorPrivate.menuItems.length / descriptorPrivate.itemsPerPage);
    };

    function MenuItem(item) {
        this.target = "";
        this.title = "";
        this.icon = "";
        this.icon_position = "";
        this.optional = "";

        if (!item || typeof item !== 'object') {
            console.log('invalid menu item: ' + item);
            return;
        }

        for (var property in item) {
            if (Object.prototype.hasOwnProperty.call(this, property)) {
                this[property] = item[property];
            }
        }
    }

    MenuItem.prototype.optionalEnabled = function (obj) {
        if (obj.title == "USB Update") {
            return window.settings.isLuxe;
        }
        if (obj.optional && obj.optional != "") {
            var val = registry.getValue(obj.optional);
            if (val != null) {
                return "1" == val;
            }
        }
        return true;
    };

    descriptorPrivate.load = function (path, cb, done) {
        $.get(path, function (data) {
            descriptorPrivate.menuItems = [];
            for (var i in data) {
                var item = new MenuItem(data[i]);
                if (item.optionalEnabled(item)) {
                    descriptorPrivate.menuItems.push(item);
                }
            }

            descriptorPrivate.menuItems
                .sort(function (a, b) {
                    return a.icon_position - b.icon_position;
                });

            cb(descriptorPrivate.menuItems.slice(0, descriptorPrivate.itemsPerPage));

            if (done) {
                done();
            }
        }, "json")
            .fail(function (jqXHR, textStatus, errorThrown) {
                console.log("failed to load menu items, status: '" + textStatus + "'");
            });
    };

    descriptorPrivate.next = function (cb) {
        descriptorPrivate.page++;
        if (descriptorPrivate.page > descriptorPrivate.pageCount() - 1) {
            descriptorPrivate.page = 0;
        }

        var start = descriptorPrivate.itemsPerPage * descriptorPrivate.page;
        cb(descriptorPrivate.menuItems.slice(
            start,
            start + descriptorPrivate.itemsPerPage));
    };

    descriptorPrivate.previous = function (cb) {
        descriptorPrivate.page--;
        if (descriptorPrivate.page < 0) {
            descriptorPrivate.page = descriptorPrivate.pageCount() - 1;
        }

        var start = descriptorPrivate.itemsPerPage * descriptorPrivate.page;
        cb(descriptorPrivate.menuItems.slice(
            start,
            start + descriptorPrivate.itemsPerPage));
    };

    descriptorPrivate.back = function (cb) {
        descriptorPrivate.page--;
        if (descriptorPrivate.page < 0) {
            descriptorPrivate.page = 0;
        }

        var start = descriptorPrivate.itemsPerPage * descriptorPrivate.page;
        cb(descriptorPrivate.menuItems.slice(
            start,
            start + descriptorPrivate.itemsPerPage));
    };
})($);
