//--XXXXboundary action script
function customPageLoad(){
    $logRecords = $("#logRecords");
    $("#progress-bar").hide();
    $('#ctrl_31').hide();
    
    //get tid/cid
    
    $.get("http://localhost/cgi-bin/hubclient/identity", function(data, status){
//        alert("Data: " + data + "\nStatus: " + status);
        if(status === "success") {
            $("#terminalId").text(data.tid);
            $("#customerId").text(data.cid);
        }
    }, "json");
    
    
    //scan button faster than log
    updateCurrentPlan();
    setInterval(function() {
        updateCurrentPlan();
    }, 1000);
    
    updateLog();
	setInterval(function() {
		var scrollLock = variableGet("scrollLock");
		if(scrollLock !== 'false') {
			updateLog();
		}
	},2000);
	
}
//--XXXXboundary action script
function onLogClear() {
    lastLogRecTimestamp = 0;
    $logRecords.empty();
}
//--XXXXboundary action script
function onStartStop() {
    //logger.debug("onStartStop");
    startStopPlan();
}
//--XXXXboundary action script
function scrollLock(response) {
    //logger.info('scroll lock: {}', response['disable-scroll']);
    variableSet("scrollLock", response['disable-scroll']);
    
}
//--XXXXboundary action script
function scrollUp() {
    var lrc = $('#ctrl_16');
    if(lrc) {
        //logger.debug('scroll up for {}px', lrc.height());
        $logRecords.scrollTop($logRecords.scrollTop() - lrc.height());
    }
}
//--XXXXboundary action script
function scrollDown() {
    var lrc = $('#ctrl_16');
    if(lrc) {
        //logger.debug('scroll down for {}px', lrc.height());
        $logRecords.scrollTop($logRecords.scrollTop() + lrc.height());
    }
}
//--XXXXboundary action script
function onConfigPageLoad() {
    $.get("http://localhost/cgi-bin/hubclient/identity", function(data, status){
        if(status === "success") {
            //todo add init values
            configData=data;
        }
    }, "json");
}
//--XXXXboundary action script
function setConfigData(type, data) {
    configData[type] = data[type];
}
//--XXXXboundary action script
function saveConfigData() {
    //logger.debug('Save configData={}', configData);
    $('body').css("background-color", "#4923a8");
    if(configData && configData.tid && configData.tid.match(/^[\w\-.]*$/) && configData.cid && configData.cid.match(/^[\w\-.]*$/)) {
        $.post("http://localhost/cgi-bin/hubclient/identity", JSON.stringify(configData), 
                function (data, status) {
                   if ( data.errorMessage ) {   
                        ui.warning(data.errorMessage).then(function () {
                            pageShow("hubclient/index.html");    
                        });
                    } else {
                        pageShow("hubclient/index.html");
                    }
                }, "json");   
    } else {
		//logger.error('Invalid configData={}', configData);
		ui.warning("Invalid data").then(function () {
            pageShow("hubclient/index.html");    
        });
    }
}
//--XXXXboundary action script
function setConfigData2(data) {
    
    //logDebug("setConfigData2 data:" + data);
    type = variableGet("entryType");
    configData[type] = data;
}
//--XXXXboundary action script
function goHomeOnCancel(response) {
    
    if (response.button === "cancel")
    {
        promptClear();
        pageShow("hubclient/index.html");
    }
}
//--XXXXboundary action script
function clearPage() {
    promptClear();
}
//--XXXXboundary action script
function loadMain(){
    $.ajax({
    dataType: 'json',
    method: 'get',
    url: '/cgi-bin/platform/sysinfo'
  }).done(function (response) {
    variableSet('hubclient.terminalModelName', response.platform.terminalModelName);
    var page = "hubclient";
    page += response.platform.terminalModelName === "LUXE8500i" ? "/phoenix/main.html" : "/griffin/main.html";
    pageShow(page);
  });
}
//--XXXXboundary action script
function customerTerminalID() {
    $.get("http://localhost/cgi-bin/hubclient/identity", function(data, status){
        if(status === "success") {
            $("#terminalId").text(data.tid);
            $("#customerId").text(data.cid);
        }
    }, "json");
}
//--XXXXboundary action script
function initRemainingActions() {
    var plansArr = ["periodicalActions", "remainingActions"];
    $.ajax('/cgi-bin/hubclient/planview', {
        type: 'GET',
        dataType: "json",
        success: function(plans) {
            if(plans && plans.planId && plans.planId.name && plans.planId.version) {
                $("#ctrl_7").text("Plan Name: "+ plans.planId.name + "     \nPlan Version: "+plans.planId.version);
            }
            var htmlContent = "<div>";
            if(plans[plansArr[0]] || plans[plansArr[1]]) {
                for (var i=0; i<plansArr.length; i++) {
                    var title = plansArr[i] === "periodicalActions" ? "Active Periodical Actions:" : "Active Remaining Actions:";
                    var plan = plans[plansArr[i]];
                    htmlContent += "<div > " + title + " </div>";
                    if(plan.length === 0){
                        htmlContent += "<ul><li >None</li></ul>"
                    } else {
                        for(p in plan){
                            htmlContent += "<ul>"
                            var name = "<li >" + plan[p].type;
                            var info = "";
                            if(plan[p].dataSet){
                                for(ds in plan[p].dataSet){
                                    if(ds === "type"){
                                        name += " " + plan[p].dataSet[ds];
                                    } else {
                                        info += plan[p].dataSet[ds] + ", ";
                                    }
                                }
                                name += ":</li>";
                                // remove last coma from info
                                if(info.length>0){
                                    info = info.substring(0, info.length - 2);
                                    info = "<li >" + info + "</li>";
                                }
                            }
                            htmlContent += name;
                            htmlContent += "<ul>" + info;
                            if(plan[p].timeCondition){
                                if(plan[p].timeCondition.startTime){
                                    htmlContent += "<li >On " + plan[p].timeCondition.startTime + "</li>"
                                }
                                if(plan[p].timeCondition.periodTimeMinutes){
                                    htmlContent += "<li >Period " + plan[p].timeCondition.periodTimeMinutes + " min</li>"
                                }
                                if(plan[p].timeCondition.waitingTimeMinutes){
                                    htmlContent += "<li >After " + plan[p].timeCondition.waitingTimeMinutes + " min</li>"
                                }
                            }
                            if(plan[p].stopSequenceOnError){
                                htmlContent += "<li >STOP sequence on error</li>";
                            }
                            htmlContent+="</ul></ul>"
                        }
                    }
                }
            } else {
                htmlContent += "<div style=\"vertical-align:middle;margin:auto;text-align:center; width:calc(100% + 25px);\">No Active Plan</div>";
            }
            htmlContent += "</div>";
            scrollableArea.initText("planSettings", htmlContent, false);
            promptEventOnly();
        },
        error: function(err, response){
            logger.error("Something went wrong while getting \"cgi-bin/hubclient/planview\". reposnseText={}, statusText={}", err.responseText || "", err.statusText || "unknown statusText");
            var htmlContent = "<div style=\"text-align:center;\"> Something went wrong while getting </br> \"cgi-bin/hubclient/planview\". </br> </br> statusText=" + err.statusText || "unknown statusText" +" </div>";
            scrollableArea.initText("planSettings", htmlContent, false);
            promptEventOnly();
        }
    });
}
//--XXXXboundary action script
