// Raw Pinpad57 with fixes 0920
// Aligned and spaced Text and Buttons 

var XAllowCashBack = 0;

var XButtonColor = "#4a25aa";
var XBannerColor = "#4a25aa";
var XSelectColor = "#000000";


var KeyCode = {
    ENTER:  0x0D,
    CANCEL: 0x1B,
    CLEAR:  0x08,
    KP_0:   0x30,
    KP_1:   0x31,
    KP_2:   0x32,
    KP_3:   0x33,
    KP_4:   0x34,
    KP_5:   0x35,
    KP_6:   0x36,
    KP_7:   0x37,
    KP_8:   0x38,
    KP_9:   0x39,
};

// For PIN_Entry dollarAmount

function calcTotal() {
  var Cb = variableGet("CB_Total");  

  if ( Cb.charAt( 1 ) == '$' ) {
    Cb = Cb.substr( 2, Cb.length - 3 );
 
    var formattedCB = Cb + "00";
    var CbAmt = parseInt( formattedCB, 10 );

    while ( formattedCB.length < 12 )
    {
        formattedCB = "0" + formattedCB;
    }
    variableSet( "CB_Total", formattedCB ); 
  }
  else {
      CbAmt = 0;
  }

  var EcrStr = variableGet("EMV.Tag.9F02");  
  
  // PAS-2063: if TransactionDisplayAmount exists then use it value
  var transactionDisplayAmount = variableGet( "TransactionDisplayAmount" );
  if ( transactionDisplayAmount )
  {
        // notify developers about invalid format
        if ( !transactionDisplayAmount.match( /^[0-9]{12}$/ ) )
        {
            console.log( "Invalid format for TransactionDisplayAmount variable. Expecting 12 digits (6 byte BCD), but got = " + transactionDisplayAmount );
            variableSet( "dollarAmount", "Error" );
            return;
        }
        EcrStr = transactionDisplayAmount;
  }
  
  var EcrAmt = parseInt( EcrStr, 10 );
  
  var TotalAmt = EcrAmt + CbAmt;
  var TotalAmtStr = TotalAmt.toString();
  
  L = TotalAmtStr.length;             // convert Amt in cents to $ Str
  var S1 = TotalAmtStr.substr(0, L-2);
  var L2 = S1.length;
  if (L2 < 1) {
      S1 = "0";
  }

  var S2 = TotalAmtStr.substr(L-2, 2);
  L2 = S2.length;
  if (L2 === 0) {
    S2 = "00";
  }
  else if (L2 === 1) {
    S2= "0" + S2;
  }
  
  var L3 = S1.length;
  if (L3 > 3) {
      var S1A = S1.substr(0, L3-3);
      var S1B = ",";
      var S1C = S1.substr(L3-3, 3);
      S1 = S1A +S1B +S1C;
  }
  
  var DollarAmtStr = "\"$" + S1 + "." + S2 + "\"";
  variableSet("dollarAmount", DollarAmtStr)
}

function isSmartCardInserted()
{
    // Done as in platform, e.g. ltib2/pkgs/platformdemo/home/platformdemo/html/views/transaction/success.html
    return scr.isSmartCardPresent() == 0;
}

function CVVPANErrorProcessing( obj )
{
    if ( obj.hasOwnProperty( "errorCode" ) &&
         obj.hasOwnProperty( "errorMsg" ) &&
         obj.hasOwnProperty( "subComponentErrorDetails" ) &&
         obj.subComponentErrorDetails.hasOwnProperty( "data" ) &&
         obj.subComponentErrorDetails.hasOwnProperty( "errorId" ) )
    {
        var errorText = obj.subComponentErrorDetails.data;
        var errorId = obj.subComponentErrorDetails.errorId;
        if ( errorText && errorId )
        {
            // Implemented according to "SCR PHX-2604 - Need separate error code on "Invalid user input""
            // "Combination of (errorId = 7) and (errorMessage = "Invalid user input") will not change - we process received from MQX event,
            // and throw exception (that is why errorId=7) with message="Invalid user input" if flag "Invalid user input" is set.
            // You can rely on this."
            if ( ( errorId == 7 ) && ( errorText == "Invalid user input" ) )
            {
                console.log( "Missed input template. Suppressed." );
                return;
            }
        }

        fireJSONEvent( "Entered", obj );
        return;   
    }

    console.log( "PAN/CVV processing failed. Error: " + JSON.stringify( obj ) );
    fireEvent( "__guiFailure" );
}

function formatAmountString( amount )
{
    return '"$"' + ( amount / 100 ).toFixed( 2 );
}

/* Stock form specific code ===========================================*/
var stock_List = [];
var stock_ProductIdx = 0;
var stock_VisibleItems = 10;    /* must match # of rows in table */

var stock_XMenuList = [];
var stock_XMenuStr = "";
var stock_XMenuPtr = 0;
var stock_XMaxMenuPtr = 0;

function stock_updateItems() {
   
    var idx;
    var $tr;
    
    //clear table
    for ( idx = 0 ; idx < stock_VisibleItems ; idx++ )
    {
        $tr = $("#stock_Id" + idx);
        $tr.find(".stock_Id").html("&nbsp;");   //need to keep line height constant
        $tr.find(".stock_Descr").text("");
        $tr.find(".stock_Qty").text("");
        $tr.find(".stock_Price").text("");
        if(idx === 0) {
            $tr.css("background-color", "");
        }
    }
    
    for ( idx = 0 ; ( idx < stock_VisibleItems ) && ( idx <= stock_ProductIdx ) && ( idx < stock_List.length ) ; idx++ ) 
    {
        var pIdx = stock_ProductIdx - idx;
        var item = stock_List[pIdx];
        
        $tr = $("#stock_Id" + idx);
        
        $tr.find(".stock_Id").text(pIdx + 1);
        $tr.find(".stock_Descr").text(item.description);
        $tr.find(".stock_Qty").text(item.qty);
        $tr.find(".stock_Price").text(item.price);
        
        if(idx===0) 
        {
            $tr.css("background-color", "#ffff00");
        }
    }
    
    variableSet( "ListIndex", stock_ProductIdx );
    
    if ( stock_List.length === 0 ) 
    {
      variableSet( "ListUpOn", "0" );
      variableSet( "ListDnOn", "0" );
      return;  
    }
	
    if ( stock_ProductIdx === 0 ) 
    {
      variableSet( "ListUpOn", "0" );
    }
    else 
    {
      variableSet( "ListUpOn", "1" );
    }

    if ( stock_ProductIdx == stock_List.length -1 ) 
    {
      variableSet( "ListDnOn", "0" );
    }
    else 
    {
      variableSet( "ListDnOn", "1" );
    }
}

// Function to return current form
function CurrentForm()
{
    function basename( path )
    {
        return path.substring( path.lastIndexOf( '/' ) + 1 );
    }
    // "application/formName.html" -> "formName.html"
    return basename( page.query() );
}

function stock_processUpdateItemsFromXML(data) {

    var $xml;
    
    try 
    {
        var xmlDoc = $.parseXML( data );      //parse string into XML document
        $xml = $( xmlDoc );                   //convert XML document into jQuery object
    } 
    catch (e) 
    {
        console.error( "stock_processUpdateItemsFromXML:, error parsing received data,  data: " + data + ", exception message: " + e.message );
        return;
    }

    var $item = $xml.find("slb_item");

    //process slb_item's 
    if ( $item.length > 0 ) 
    {
        $item.each( function () 
        {
            var item = $( this );

            var description = item.find( "description" ).text();
            var qty = item.find( "qty" ).text();
            var price = item.find( "price" ).text();

            stock_List.push( { description: description, qty: qty, price: price } );
            stock_ProductIdx = stock_List.length - 1;
        });

        //persist product list 
        variableSet( "ListJSON", JSON.stringify( stock_List ) );
    }

    //process slb_clear command, if exist
    var $clear = $xml.find( "clear" );
    if ( $clear.length == 1 ) 
    {
        //clear all
        stock_List = [];
        variableSet( "ListJSON", JSON.stringify( [] ) );
        
        //reset totals
        variableSet( "slb.subtotal", "" );
        variableSet( "slb.tax", "" );
        variableSet( "slb.discount", "" );
        variableSet( "slb.total", "" );
    }
    
    //process slb_total command, if exist
    var $total = $xml.find( "slb_total" );
    if ( $total.length == 1 ) 
    {
        var $subtotal = $total.find( "subtotal" );
        if( $subtotal.length == 1 ) 
        {
            variableSet( "slb.subtotal", $subtotal.text() );
        }
        var $tax = $total.find( "tax" );
        if( $tax.length == 1 ) 
        {
            variableSet( "slb.tax", $tax.text() );
        }
        $discount = $total.find( "discount" );
        if( $discount.length == 1 )
        {
            variableSet( "slb.discount", $discount.text() );
        }
        $total = $total.find( "total" );
        if( $total.length == 1 ) 
        {
            variableSet( "slb.total", $total.text() );
        }
    }

    //update view
    stock_updateItems();
}

function stock_displayMenuBtns() 
{
   var y = 0;
   var z = 0;
   var Name = "";
   var Val = "";
   
   stock_clearMenuBtns();
   
   for ( var x = 0; x < 5; x++ ) 
   {
      y = x +1;
      z = stock_XMenuPtr + x;
      
      if ( y > stock_XMaxMenuPtr ) 
      { 
        return; 
      }
        
      Name = "menu" + y;
      Val = stock_XMenuList[ z ];
      
      variableSet ( Name, Val );
   }
   
   stock_hideUpDn();
}

function stock_clearMenuBtns() 
{
   for ( var x = 1; x < 6; x++ ) 
   {
      variableSet ( "menu" + x, "" );
   }
}

function stock_loadMenuList() 
{
   stock_XMenuStr = variableGet( "MenuList" );
   stock_clearMenuBtns();
   
   if ( stock_XMenuStr === undefined || stock_XMenuStr === null || stock_XMenuStr === "" )
   {
      stock_XMenuList = [];  // Clears XMenuStr
      return;
   }
  
   stock_XMenuList = stock_XMenuStr.split( "," );
   stock_XMaxMenuPtr = ( stock_XMenuList.length -1 );
   stock_displayMenuBtns();
}

function stock_UpdateBatteryCapacityIndicator()
{
    registerForVariable( "power-manager.battery.capacity", function()
    {
        UpdateCapacityIndicatorVariable();
    });

    UpdateCapacityIndicatorVariable();
    
    function UpdateCapacityIndicatorVariable()
    {
        var capacity = variableGet( "power-manager.battery.capacity" );
        if (capacity != "n/a") {
            variableSet( "stock.battery.capacity", capacity+"%" )
        } else {
            variableSet( "stock.battery.capacity", " " )
        }
    }
}

stock_UpdateBatteryCapacityIndicator();