// MQX UI wrapper
(function (window, document, $) {
    var logfn;
    if (typeof log !== 'undefined' && log.error) {
        logfn = log.error;
    } else if (typeof console !== 'undefined' && console.log) {
        logfn = console.log;
    } else {
        throw { message: "$MQX library error: logging is not available" };
    }

    if (typeof window.$MQX !== 'undefined') {
        logfn("failed to initialize $MQX library: already defined");
        return;
    } else if (typeof $ === 'undefined') {
        logfn("error: $MQX library requires jQuery");
        return;
    }

    var cancelFn = [];
    window.$MQX = {
        cancel: function (fn) {
            cancelFn.push(fn);
        },

        restartUI: function () {
            if (window.$MQX.lastTimeout) {
                clearTimeout(window.$MQX.lastTimeout);
                window.$MQX.lastTimeout = 0;
            }

            window.$MQX.lastTimeout = setTimeout(function () {
                try {
                    $MQX.start();
                    window.$MQX.lastTimeout = 0;
                } catch (e) {
                    logfn('failed to restart secure input: ' + e.message);
                }
            }, 50);
        },

        start: function () {
            var buttons = $('.eqp-button:visible');
            if (!buttons.length) {
                throw { message: "no visible buttons found to attach to" };
            }

            var mqxbtn = function (e) {
                var elem = $(e);

                var offs = elem.offset();
                if (!offs) {
                    throw { message: "failed to get element offset" };
                }

                var name = offs.left + ':' + offs.top;

                if (!e.id) {
                    throw { message: "failed to get element ID" };
                }

                if (e.id.length > 14) {
                    throw { message: "element ID is too long: " + e.id };
                }

                var text = '#' + e.id;

                if (offs.left < 0 || offs.top < 0 || elem.outerWidth() < 5 || elem.outerHeight() < 5) {
                    throw { message: "invalid element offset (" + e.id + ")" };
                }

                var buttonHeight = elem.outerHeight();

                var screenHeightExceeded = buttonHeight + offs.top - screen.height;
                if (screenHeightExceeded > 0) {
                    buttonHeight -= screenHeightExceeded;
                }

                var res = secure.promptButton(name, text, offs.left, offs.top,
                    elem.outerWidth(), buttonHeight, '');
                if (res) {
                    throw { message: "promptButton failed (result code " + res + ")" };
                }
            };

            secure.promptClear();
            buttons.each(function () {
                mqxbtn(this);
            });

            var minX = settings.horizontalSwipe === false ? 0 : 100;
            secure.promptGesture("abc", 0, minX, 100);

            var res = secure.promptEvent(-1);
            if (res && res.status) {
                throw { message: "secure.promptStart failed with ( status " + res.status + ")" };
            }
        },

        beep: function () {
            tools.beep(1, 5000, 17, 0);
        },

        attach: function () {
            secure.onSecureInput.connect(function (data) {
                if (typeof data == 'undefined') {
                    data = [];
                }

                try {
                    for (var i in data) {
                        // physical cancel button
                        if (i == 'button' && data[i] == 'cancel') {
                            if (!cancelFn.length) {
                                break;
                            }

                            for (var j in cancelFn) {
                                try {
                                    cancelFn[j]();
                                } catch (e) {
                                    logfn('invalid cancel function: ' + e.message);
                                }
                            }
                            break;
                        }

                        // editbox text entered ?
                        if ($('#' + i).hasClass('edit-box') || $('#' + i).hasClass('eqp-text-button')) {
                            $('#' + i).val(data[i]);
                            $('#' + i).trigger('change');
                            break;
                        }

                        var e = $(data[i] + ':visible');
                        if (!e.length) {
                            // logfn( "no visible buttons found" );
                        }
                        // show edit box ?
                        var chld = e.find('.edit-box');
                        if (chld.length) {
                            $MQX.createTextBox(chld[0]);
                            return;
                        }

                        if (e.hasClass('eqp-text-button')) {
                            e.id = data[i].slice(1);
                            e.value = $(data[i]).val();
                            $MQX.createTextBox(e);
                            return;
                        }

                        // inputs
                        var inputs = e.find('input');
                        if (inputs.length) {
                            e = inputs[0];
                        }

                        $(e).click();
                    } // for

                    window.$MQX.restartUI();
                } catch (ex) {
                    var msg = 'failed to create secure input control: ' + ex.message;
                    logfn(msg);

                    setTimeout(function () {
                        page.showPage("http://localhost/cgi-bin/page/show?path=" + window.settings.appName + "/index.html");
                    }, 5000);
                }
            });
        }, // attach : function

        createTextBox: function ($elem) {
            var id = $elem.id;
            var initialValue = $elem.value;
            var template  = $($elem).attr('eqp-template');
            var font  = $($elem).attr('eqp-font');

            if (!id) {
                throw { message: 'could not create text box, missing element id' };
            }
            secure.promptClear();

            var res,
                isLuxe = window.settings.isLuxe;
            if (isLuxe) {
                res = secure.promptImage('defapp_textbox', 0, 0);
            } else {
                res = secure.promptImage('default-txt', 0, 0);
            }

            if (res) {
                throw { message: 'prompt image failed' };
            }

            if (isLuxe) {
                res = secure.promptButton('button', 'ok', 683, 413, 114, 64);
            } else {
                res = secure.promptButton('button', 'ok', 275, 215, 44, 24);
            }

            if (res) {
                throw { message: 'prompt button failed' };
            }

            res = secure.promptTextbox({
                name: id,
                textTemplate: template ? template : "@@@@@@@@@@@@@@@@@@@@",
                initialString: initialValue ? initialValue : "",
                x: isLuxe ? 155 : 30,
                y: isLuxe ? 105 : 30,
                w: isLuxe ? 460 : 240,
                h: isLuxe ? 40 : 30,
                valign: 0,
                halign: 0,
                kbdx: 0,
                kbdy: isLuxe ? 200 : 119,
                fontname: font,
                kbdname: isLuxe ? "keyboard0" : "grif0"
            });
            if (res) {
                throw { message: 'prompt textbox failed' };
            }

            res = secure.promptEvent(-1);
            // if ( res ) { throw { message: 'prompt event failed' }; }

            // if ( res ) {
            //     throw { message: 'textbox prompt error (see system log)' };
            // }
        } // createTextBox: function
    }; // window.$MQX

    $(document).ready(function () {
        try {
            $MQX.attach();
            $MQX.start();
        } catch (e) {
            logfn('$MQX initialization failed: ' + e.message);
        }
    });
}(window, document, jQuery));
