(function ($) {
    window.productiontest = window.productiontest || {};

    var infoImp = {};

    window.productiontest.info = {
        // args.success = function(terminalInfo {})
        // args.fail = function(msg)
        terminalInfo: function (args) {
            infoImp.terminalInfo(args);
        },

        // args.success = function(sysinfo)
        // args.fail = function(msg)
        getSysInfo: function (args) {
            infoImp.getSysInfo(args);
        },

        getVersionInfo: function (args) {
            infoImp.getVersionInfo(args);
        },

        getFCCInfo: function (args) {
            infoImp.getFCCInfo(args);
        }
    };

    ////////////////////////////////////////////////////////////////////////////
    //  IMPL
    ////////////////////////////////////////////////////////////////////////////

    // infoImpl
    (function () {
        infoImp.terminalInfo = function (args) {
            $.get("/cgi-bin/platform/sysinfo?short_list", function (data) {
                args.success(data);
            });
        };

        infoImp.getVersionInfo = function (args) {
            var xhttp = new XMLHttpRequest();
            xhttp.onreadystatechange = function () {
                try {
                    if (this.readyState == this.DONE && this.status == 200) {
                        if (this.responseText && this.responseText.length) {
                            args.success(this.responseText);
                        } else {
                            args.fail('http error');
                        }
                    } // if
                } catch (e) {
                    args.fail(e.message);
                }
            };
            var url = "/html/platform/version_info.html";
            xhttp.open("GET", url, true);
            xhttp.send();
        };

        infoImp.getSysInfo = function (args) {
            var xhttp = new XMLHttpRequest();
            xhttp.onreadystatechange = function () {
                try {
                    if (this.readyState == this.DONE && this.status == 200) {
                        if (this.responseText && this.responseText.length) {
                            args.success(JSON.parse(this.responseText));
                        } else {
                            args.fail('unknown error');
                        }
                    } // if
                } catch (e) {
                    args.fail(e.message);
                }
            };
            xhttp.open("GET", "/cgi-bin/platform/sysinfo", true);
            xhttp.send();
        };

        infoImp.getFCCInfo = function (args) {
            var xhttp = new XMLHttpRequest();
            xhttp.onreadystatechange = function () {
                try {
                    if (this.readyState == this.DONE && this.status == 200) {
                        if (this.responseText && this.responseText.length) {
                            args.success(JSON.parse(this.responseText));
                        } else {
                            args.fail('unknown error');
                        }
                    } // if
                } catch (e) {
                    args.fail(e.message);
                }
            };
            xhttp.open("GET", "/cgi-bin/platform/fccinfo", true);
            xhttp.send();
        };

    })();

})(jQuery);
