//==============================================================================
//  Company:
//      Equinox Payments, LLC
//
//  Product:
//      Apple Pay plugin for NFC arbitrator
//      Copyright 2011-2023 Equinox Payments, LLC
//
//  \brief
//      Apple Pay plugin for NFC arbitrator
//
//==============================================================================

#pragma once

enum class ApplePayPluginErrorCode
{
    DifferentWallet        = 0x0000, // Application ID in response is not ApplePay, it is a different wallet.
    SelectReturnedExtra6F  = 0x0001, // ApplePay Select response has more than one 6F template
    SelectReturnedNot6F    = 0x0002, // ApplePay Select response template is not 6F
    DataExchangeFailed     = 0x0003, // Failed to read data from phone, NFC data exchange failed
    WrongP1P2              = 0x0004, // Response from phone: Wrong P1, P2
    WrongLengthInCommand   = 0x0005, // Response from phone: Wrong length of command data field.
    SeePhone               = 0x0006, // Response from phone: See phone for instructions
    IncorrectDataInCommand = 0x0007, // Response from phone: Incorrect data in command field
    WalletNotActivated     = 0x0008, // Response from phone: VAS Data Not Activated
    UnknownSWBytes         = 0x0009, // Unknown SW bytes on ApplePay select
    ResponseNotTVL         = 0x0010, // Response is not valid TLV
    ResponseTemplateNot70  = 0x0011, // Template name of VAS data read response is not 70
    NoData                 = 0x0012, // Apple Pay VAS Read None, no loyalty card data to read

    Undefined              = 0xFFFF,
};
