function MenuItem(item) {
    this.target = "";
    this.title = "";
    this.icon = "";
    this.icon_position = "";
    this.optional = "";

    if (!item || typeof item !== 'object') {
        console.log('invalid menu item: ' + item);
        return;
    }

    for (var property in item) {
        if (this.hasOwnProperty(property)) {
            this[property] = item[property];
        }
    }
}

MenuItem.prototype.OptionalEnabled = function (obj) {
    if (obj.title == "Flashlight") {
        return tools.flAvailable() == 1;
    } else if (obj.title == "USB Update") {
        return window.settings.isLuxe;
    }

    if (obj.optional != "") {
        var val = registry.getValue(obj.optional);
        if (val === null) {
            return false;
        }

        return "1" == val;
    }
    return true;
};
