function showWarning( msg ) {
    $( "#warning" ).html( msg ).show();
    setTimeout( function() {
        $( "#warning" ).empty().hide();
    }, 5000 );
}

function createNavigation() {
    var next = "assets/images/next.svg",
        prev = "assets/images/prev.svg";
    $( "figure:last" )
        .append( "<img src=\"" + next + "\"/>" )
        .data( "direction", "next" )
        .click( function() {
            var figure = $( this );
            animateDesktopItem( figure );
            if( figure.data( "direction" ) === "next" ) {
                if( currentPageIndex + 1 === pageCount - 1 ) {
                    figure.find( "img" ).first().attr( "src", prev );
                    figure.data( "direction", "prev" );
                }
                currentPageIndex++;
            }
            else {
                if( currentPageIndex - 1 === 0 ) {
                    figure.find( "img" ).first().attr( "src", next );
                    figure.data( "direction", "next" );
                }
                currentPageIndex--;
            }
            showPage();
        }
    );
}

function attachSecureInput() {
    var createButton = function( btn, id ) {
        var left   = btn.offset().left,
            top    = btn.offset().top,
            width  = btn.outerWidth(),
            height = btn.outerHeight();

        return secure.promptButton( id, id, left, top, width, height );
    };

    secure.promptClear();
    $( ".menu-item,.close" ).each( function( i ) {
        try {
            var res = createButton( $( this ), this.id );
        } catch(e) {
            console.log( "failed to create secure input button: " + e.message );
        }
    });
    secure.promptGesture( "abc", 0, 100, 100 );
    var res = secure.promptEvent( 0x7FFFFFFF );
    if ( res.status ) {
        console.log( "secure.promptEvent failed: " + JSON.stringify( res ) );
    }
}

secure.onSecureInput.connect( function( data ) {
    secure.promptEvent(-1);

    for( var i in data ) {
        $(".menu-item").removeClass("selected");
        var id = "#" + data[i];
        var el = $(id);

        el.addClass("selected");
        el.click();

        return;
    }
});

$('document').ready(function(){
    var createMenuItem = function( menuItem, id ) {
                            var el = document.createElement("DIV");
                            el.className = "menu-item";
                            el.id = id;

                            // icon
                            var div = $(el);
                            if( menuItem.icon ) {
                                div.append( "<div class='icon'><img src='" + menuItem.icon + "'/></div>" );
                            }

                            // text
                            if( menuItem.title ) {
                                div.append( "<div class='title'>" + menuItem.title + "</div>" );
                            }

                            // on click
                            div.click(function(){
                                var path = menuItem.target.replace( /^html\//, window.settings.appName + "/" );
                                var rc = page.showPage( "/cgi-bin/page/show?path=" + encodeURI( path ) );
                                if( rc !== 0 ) {
                                    console.log( "cannot show page: " + path );
                                }
                            });

                            document.getElementById('menu').appendChild(el);
                        };
    var menuHandler = function( menuItems ) {
                        $("#menu").empty();

                        var id = 1;
                        for( var i in menuItems ) {
                            createMenuItem( menuItems[i], id++ );
                        }
                        createNextButton();
                        attachSecureInput();
                    };

    // *next* button
    var createNextButton = function(){
                            if ( window.descriptor.pageCount() < 2 ) {
                                return;
                            }

                            var el = document.createElement("DIV");
                            el.className = "menu-item";
                            el.id = "btn-next";

                            // icon
                            var div = $(el);
                            div.append( "<div class='icon'><img src='assets/images/next.png'/></div>" );

                            // text
                            div.append( "<div class='title'>Next</div>" );

                            // on click
                            div.click(function(){
                                window.descriptor.next(menuHandler);
                            });

                            document.getElementById('menu').appendChild(el);
                        };
                        
                        var scrollLeft = function () {
                            try {
                                window.descriptor.next(menuHandler);
                            } catch( e )  {
                                console.log( 'error: ' + e.message );
                            }
                        };

                        var scrollRight = function () {
                            try {
                                window.descriptor.previous(menuHandler);
                            } catch( e )  {
                                console.log( 'error: ' + e.message );
                            }
                        };

                        secure.onGesture.connect( function( data ) {
                            try {
                                if( !data ) {
                                    return;
                                }
                                if ( data['type'] == 'end' )
                                {
                                	if ( data['x'] > 0 )
                                	{
                                		scrollLeft();
                                	}
                                	else
                               		{
                                		scrollRight();
                               		}
                                }
                            } catch(e) {
                                console.log( 'onGesture err: ' + e.message );
                            }
                        });
                        
                        
    window.descriptor.load('/files/' + window.settings.appName + '/descriptor.json',
                           menuHandler);

     // beeper
     try {
         secure.toggleBeeper(true);
         secure.setBeeperParams(2000,500,30);
     } catch(e) {
         console.log("failed to set beeper params: " + e.message);
     }
});
