function displayBLE() {
    var isPresent = registry.getValue('network.ble.presence');
    if (isPresent == 0) {
        $("#ble").css('display', 'none');
    } else {
        var enable = registry.getValue('network.ble.enable');
        if (enable == 1) {
            var status = registry.getValue('network.ble.status');
            if (status == "idle" || status == "advertise" || status == "display passkey") {
                $('#ble').attr('src', '/html/systemconfig/assets/images/bt.png');
            } else if (status == "connected") {
                $('#ble').attr('src', '/html/systemconfig/assets/images/bt_connected.png');
            } else {
                $('#ble').attr('src', '/html/systemconfig/assets/images/bt_fail.png');
                console.log("Unexpected value of network.ble.status: " + status);
            }
        } else {
            $("#ble").attr('src', '/html/systemconfig/assets/images/bt_fail.png');
        }
        $("#ble").css('display', 'block');
    }
}

function displayWLAN() {
    var isPresent = registry.getValue('network.wifi.presence');
    if (isPresent == 0) {
        $("#wlan").css('display', 'none');
        $("#wlan_txt").css('display', 'none');
        $("#wlan_space").css('display', 'none');
    } else {
        var state = registry.getValue('network.wifi.net.state');
        if (state == 'completed') {
            var level = registry.getValue('network.wifi.net.signal');
            $("#wlan_txt").text(level + '%');
            if (level < 40) {
                $("#wlan").attr('src', '/html/systemconfig/assets/images/wlan_red.png');
            } else if (level < 70) {
                $("#wlan").attr('src', '/html/systemconfig/assets/images/wlan_yellow.png');
            } else {
                $("#wlan").attr('src', '/html/systemconfig/assets/images/wlan_green.png');
            }
            $("#wlan_txt").css('display', 'block');
        } else {
            $("#wlan").attr('src', '/html/systemconfig/assets/images/wlan_grey.png');
            $("#wlan_txt").css('display', 'none');
        }
        $("#wlan").css('display', 'block');
        $("#wlan_space").css('display', 'block');
    }
}

function displayLTE() {
    var isPresent = registry.getValue('network.lte.presence');
    if (isPresent == 0) {
        $("#lte").css('display', 'none');
        $("#lte_txt").css('display', 'none');
        $("#lte_space").css('display', 'none');
    } else {
        var state = registry.getValue('network.lte.state');
        if (state == 'connected') {
            var level = registry.getValue('network.lte.signal');
            $("#lte_txt").text(level + '%');
            if (level < 40) {
                $("#lte").attr('src', '/html/systemconfig/assets/images/lte_red.png');
            } else if (level < 70) {
                $("#lte").attr('src', '/html/systemconfig/assets/images/lte_yellow.png');
            } else {
                $("#lte").attr('src', '/html/systemconfig/assets/images/lte_green.png');
            }
            $("#lte_txt").css('display', 'block');
        } else {
            $("#lte").attr('src', '/html/systemconfig/assets/images/lte_grey.png');
            $("#lte_txt").css('display', 'none');
        }
        $("#lte").css('display', 'block');
        $("#lte_space").css('display', 'block');
    }
}

function displayBattery() {
    var state = registry.getValue('power-manager.battery.state');
    if (state == 'n/a' || state == 0) {
        $("#bat").css('display', 'none');
        $("#bat_txt").css('display', 'none');
        $("#bat_space").css('display', 'none');
    } else {
        var level = registry.getValue('power-manager.battery.capacity');
        $("#bat_txt").text(level + '%');
        if (state == 1) {
            $("#bat").attr('src', '/html/systemconfig/assets/images/battery_charging.png');
        } else if (state == 4) {
            $("#bat").attr('src', '/html/systemconfig/assets/images/battery_green_full.png');
        } else {
            if (level < 5) {
                $("#bat").attr('src', '/html/systemconfig/assets/images/battery_red.png');
            } else if (level < 15) {
                $("#bat").attr('src', '/html/systemconfig/assets/images/battery_orange.png');
            } else if (level < 30) {
                $("#bat").attr('src', '/html/systemconfig/assets/images/battery_yellow_20.png');
            } else if (level < 40) {
                $("#bat").attr('src', '/html/systemconfig/assets/images/battery_yellow_30.png');
            } else if (level < 50) {
                $("#bat").attr('src', '/html/systemconfig/assets/images/battery_yellow_40.png');
            } else if (level < 60) {
                $("#bat").attr('src', '/html/systemconfig/assets/images/battery_yellow_50.png');
            } else if (level < 70) {
                $("#bat").attr('src', '/html/systemconfig/assets/images/battery_yellow_60.png');
            } else if (level < 80) {
                $("#bat").attr('src', '/html/systemconfig/assets/images/battery_yellow_70.png');
            } else if (level < 90) {
                $("#bat").attr('src', '/html/systemconfig/assets/images/battery_yellow_80.png');
            } else {
                $("#bat").attr('src', '/html/systemconfig/assets/images/battery_green.png');
            }
        }
        $("#bat").css('display', 'block');
        $("#bat_txt").css('display', 'block');
        $("#bat_space").css('display', 'block');
    }
}

function onRegistryValueChanged(k, v) {
    if (k == "network.wifi.net.state" ||
        k == "network.wifi.net.signal") {
        displayWLAN();
    } else if (k == "network.lte.state" ||
               k == "network.lte.signal") {
        displayLTE();
    } else if (k == "network.ble.enable" ||
               k == "network.ble.status") {
        displayBLE();
    } else if (k == "power-manager.battery.state" ||
               k == "power-manager.battery.capacity") {
        displayBattery();
    }
}

function displayStatusBar() {
    displayBLE();
    displayBattery();
    displayWLAN();
    displayLTE();
}

function initStatusBar() {
    registry.valueChanged.connect(onRegistryValueChanged);
    registry.subscribe("network.wifi.net.state");
    registry.subscribe("network.wifi.net.signal");
    registry.subscribe("network.lte.state");
    registry.subscribe("network.lte.signal");
    registry.subscribe("network.ble.enable");
    registry.subscribe("network.ble.status");
    registry.subscribe("power-manager.battery.state");
    registry.subscribe("power-manager.battery.capacity");

    displayStatusBar();
    adjustTitleWidth();
}

function adjustTitleWidth() {
    var positionInfo = document.getElementById('sb-left').getBoundingClientRect();
    var left = positionInfo.left;
    var maxTitleWidth = left + "px";
    document.getElementById('form-title').style.maxWidth = maxTitleWidth;
    document.getElementById('form-title').style.width = maxTitleWidth;
}

function buildStatusBar() {
    $("#status-bar").load("/html/systemconfig/assets/html/status-bar.html", function () {
        initStatusBar();
    });
}

(function () {
    buildStatusBar();
})();

