// Raw Pinpad57 with fixes 0920
// Aligned and spaced Text and Buttons 

var XAllowCashBack = 0;

var XButtonColor = "#4a25aa";
var XBannerColor = "#4a25aa";
var XSelectColor = "#000000";


var KeyCode = {
    ENTER:  0x0D,
    CANCEL: 0x1B,
    CLEAR:  0x08,
    KP_0:   0x30,
    KP_1:   0x31,
    KP_2:   0x32,
    KP_3:   0x33,
    KP_4:   0x34,
    KP_5:   0x35,
    KP_6:   0x36,
    KP_7:   0x37,
    KP_8:   0x38,
    KP_9:   0x39,
};

// For PIN_Entry dollarAmount

function calcTotal() {
  var Cb = variableGet("CB_Total");  

  if ( Cb.charAt( 1 ) == '$' ) {
    Cb = Cb.substr( 2, Cb.length - 3 );
 
    var formattedCB = Cb + "00";
    var CbAmt = parseInt( formattedCB, 10 );

    while ( formattedCB.length < 12 )
    {
        formattedCB = "0" + formattedCB;
    }
    variableSet( "CB_Total", formattedCB ); 
  }
  else {
      CbAmt = 0;
  }

  var EcrStr = variableGet("EMV.Tag.9F02");  
  
  // PAS-2063: if TransactionDisplayAmount exists then use it value
  var transactionDisplayAmount = variableGet( "TransactionDisplayAmount" );
  if ( transactionDisplayAmount )
  {
        // notify developers about invalid format
        if ( !transactionDisplayAmount.match( /^[0-9]{12}$/ ) )
        {
            console.log( "Invalid format for TransactionDisplayAmount variable. Expecting 12 digits (6 byte BCD), but got = " + transactionDisplayAmount );
            variableSet( "dollarAmount", "Error" );
            return;
        }
        EcrStr = transactionDisplayAmount;
  }
  
  var EcrAmt = parseInt( EcrStr, 10 );
  
  var TotalAmt = EcrAmt + CbAmt;
  var TotalAmtStr = TotalAmt.toString();
  
  L = TotalAmtStr.length;             // convert Amt in cents to $ Str
  var S1 = TotalAmtStr.substr(0, L-2);
  var L2 = S1.length;
  if (L2 < 1) {
      S1 = "0";
  }

  var S2 = TotalAmtStr.substr(L-2, 2);
  L2 = S2.length;
  if (L2 === 0) {
    S2 = "00";
  }
  else if (L2 === 1) {
    S2= "0" + S2;
  }
  
  var L3 = S1.length;
  if (L3 > 3) {
      var S1A = S1.substr(0, L3-3);
      var S1B = ",";
      var S1C = S1.substr(L3-3, 3);
      S1 = S1A +S1B +S1C;
  }
  
  var DollarAmtStr = "\"$" + S1 + "." + S2 + "\"";
  variableSet("dollarAmount", DollarAmtStr)
}

function isSmartCardInserted()
{
    // Done as in platform, e.g. ltib2/pkgs/platformdemo/home/platformdemo/html/views/transaction/success.html
    return scr.isSmartCardPresent() == 0;
}

function CVVPANErrorProcessing( obj )
{
    if ( obj.hasOwnProperty( "errorCode" ) &&
         obj.hasOwnProperty( "errorMsg" ) &&
         obj.hasOwnProperty( "subComponentErrorDetails" ) &&
         obj.subComponentErrorDetails.hasOwnProperty( "data" ) &&
         obj.subComponentErrorDetails.hasOwnProperty( "errorId" ) )
    {
        var errorText = obj.subComponentErrorDetails.data;
        var errorId = obj.subComponentErrorDetails.errorId;
        if ( errorText && errorId )
        {
            // Implemented according to "SCR PHX-2604 - Need separate error code on "Invalid user input""
            // "Combination of (errorId = 7) and (errorMessage = "Invalid user input") will not change - we process received from MQX event,
            // and throw exception (that is why errorId=7) with message="Invalid user input" if flag "Invalid user input" is set.
            // You can rely on this."
            if ( ( errorId == 7 ) && ( errorText == "Invalid user input" ) )
            {
                console.log( "Missed input template. Suppressed." );
                return;
            }
        }

        fireJSONEvent( "Entered", obj );
        return;   
    }

    console.log( "PAN/CVV processing failed. Error: " + JSON.stringify( obj ) );
    fireEvent( "__guiFailure" );
}

function formatAmountString( amount )
{
    return '"$"' + ( amount / 100 ).toFixed( 2 );
}
