(function ($) {
    window.settings = {
        appName: "systemutils",

        showPage: function (pagePath) {
            page.showPage("//localhost/cgi-bin/page/show?path=" + window.settings.appName + "/" + pagePath);
        }
    };

    window.settings.keys = {
        // args.success = function()
        // args.fail = function(msg)
        inject: function (args) {
            $.ajax({
                type: "GET",
                url: '//localhost/cgi-bin/platform/key?function=local&quiet=1',
                success: function (data, status, xhr) {
                    var $xml = $(data),
                        result = $xml.find("result").text();
                    var success = '0' == result;
                    if (success) {
                        args.success();
                    } else {
                        args.fail(result);
                    }
                },
                error: function () {
                    args.fail("http error");
                }
            });
        }
    };
})(jQuery);

window.settings.isLuxe = screen.width > 320;

// session
(function () {
    window.session = window.session || {};

    window.session.path = settings.appName + ".session";

    window.session.set = function (data) {
        registry.setValue(window.session.path, JSON.stringify(data));
    };

    window.session.get = function () {
        return JSON.parse(registry.getValue(window.session.path));
    };

    window.session.clear = function () {
        window.session.set(null);
    };
})();
