// logger.setLogLevel('debug');
var navItems = {
    home: {title: 'Home', icon: 'assets/images/home.png', position: 3},
    logout: {title: 'Logout', icon: 'assets/images/close32.png', position: 3},
    next: {title: 'Next', icon: 'assets/images/next.png', position: 7},
    setup: {title: 'Setup', icon: 'assets/images/setup.png'}
};

registerForEvent("onKeypad", "keypad", function(name, text, response) {
    if (text === 8){
        desktopManager.showPrevious();
    }
});

secure.onSecureInput.connect(function (data) {
    for (var property in data) {
        if (data[property] === 'close') {
            goToHomeApp();
        } else {
            if (data[property].indexOf("menu-item-")!== -1 || data[property] === "btn-home" || data[property] === "btn-home-abs" || data[property] === "btn-next" || data[property] === "btn-next-abs") {
                updateInactivityTimeout();
                var id = "#" + data[property];
                var el = $(id);
                el.click();    
                return;
            } else if (data[property] === "btn-logout" || data[property] === "btn-logout-abs") {
                // logout
                logout();
            }
        }
    }
});

var timeout = null;
var waitTime = 30 * 60 * 1000; // = 30min.
function updateInactivityTimeout() {
    isWebAuthEnabled().then(function(isEnabled){
        if(isEnabled){
            setLastActionTime(new Date().getTime()).then(function(result){})
            clearTimeout(timeout);
            timeout = setTimeout(function() {
                logout();
            }, waitTime);
        }
    });
}

function menuItemClickFn(menuItem, app, preview) {
    return function () {
        $("#loading").show();

        menuItem.removeClass('menu-item-selected');
        void menuItem.offset();
        menuItem.addClass('menu-item-selected');

        menuItem.on("animationend webkitAnimationEnd", function (e) {
            if (app.title === navItems.home.title) {
                // goToHomeApp();
                desktopManager.lastItem = 0;
                desktopManager.show();
            } else if (app.title === navItems.next.title) {
                desktopManager.showNext();
            } else if (app.title === navItems.setup.title) {
                desktopManager.showSetup();
            } else {
                var page = app.page;
                if (page.indexOf('/html/') === 0) {
                    page = page.replace('/html/', '');
                    //page = app.appName + '/' + page;
                }
                pageShow(page);
            }

            $("#loading").hide();
            menuItem.off(e);
        });
    };
}

var desktopManager = {
    apps: [],
    setupApps: [],
    page: 0,
    preview: 'apps',
    lastItem: 0,
    webAuthEnabled: false,
    
    attachSecureInput: function () {
        
        var createButton = function( btn, id ) {
            var left = btn.offset().left,
            top      = btn.offset().top,
            width    = btn.outerWidth(),
            height   = btn.outerHeight();
            return secure.promptButton( id, id, left, top, width, height );
        };

        secure.promptClear();
        $( ".menu-item-box" ).each( function( i ) {
          try {
            var res = createButton( $( this ), this.id );
          } catch(e) {
            // failed to create secure input button:
            // console.log( "failed to create secure input button: " + e.message );
          }
        });
        var res = secure.promptEvent( 0x7FFFFFFF );
        if ( res.status ) {
            // console.log( "secure.promptEvent failed: " + JSON.stringify( res ) );
        }
    },

    _show: function () {
        
        $("#menu").empty();

        var apps = this.apps.slice(0);
        var page = this.page;
        var preview = this.preview;

        var totalPages = 1;
        //change to setupApps 
        if (preview === 'setup') {
            apps = this.setupApps;
            totalPages = Math.ceil(apps.length / 6)
        } else {
            $('#pageTitle').text('Desktop');
            totalPages = (apps.length <= 1) ? 1 : Math.ceil((apps.length - 1) / 5)
        }
        var totalAppsLength = apps.length;
  
        $("#pageNumber").text('Page ' + (page + 1) + ' / ' + totalPages);
        // to grab 1 app less 
        // - for Desktop home btn if page !== 0
        // - for Desktop Logout button when webAuthEnabled is enabled
        var end = ((!this.webAuthEnabled) && (page === 0)) ? this.lastItem + 6 : (preview === 'setup') ? this.lastItem + 6 : this.lastItem + 5;
        apps = apps.slice(this.lastItem, end);
        // save last item that is in menu
        this.lastItem = end;
        if (preview !== 'setup') {
            // add setup btn if preview is desktop
            apps.push(navItems.setup);

            if (page === 0 && this.webAuthEnabled){
                // adds logout button if preview is desktop and page is 0 and webAuthEnabled is true
                apps.splice(navItems.logout.position, 0, navItems.logout);
            }
        }
        
        if(preview === "setup" || page !== 0){
            // adds home btn if preview is setup or page is not 0
            apps.splice(navItems.home.position, 0, navItems.home);
        }
        // adds next btn if there are more than one page
        if (totalAppsLength > 6){
            apps.push(navItems.next);
        }
        
        // render apps in menu
        for(var i = 0; i < apps.length; i++) {
            var app = apps[i];
            var el = document.createElement("DIV");
            el.className = "menu-item-box";
            
            el.id = (app.title === "Home") ? "btn-home" : (app.title === "Next") ? "btn-next" : (app.title === "Logout") ? "btn-logout" : "menu-item-" + i;
            if(el.id === "btn-home" && i !== 3){
                el.id = "btn-home-abs";
            }
            if(el.id === "btn-logout" && i !== 3){
                el.id = "btn-logout-abs";
            }
            if(el.id === "btn-next" && i !== 7){
                el.id = "btn-next-abs";
            }
  
            var div = $(el);
            if (app.icon.indexOf('html/') === 0) {
                app.icon = app.icon.replace('html/', '');
                app.icon = '/html/' + app.appName + '/' + app.icon;
            }
            div.append('<div class="menu-item-icon-container"><img src="' + app.icon + '" class="menu-item-icon" /></div>');
            div.append('<div class="menu-item-title">' + app.title + '</div>');
            div.click(menuItemClickFn(div, app, preview));
            document.getElementById("menu").appendChild(el);
        }
        desktopManager.attachSecureInput();
        $("#loading").hide();
    },
    
    showNext: function () {
        this.page++;
        if (this.preview === 'apps' && this.apps.length <= this.lastItem){
            this.page = 0;
            this.lastItem = 0;
        } else if (this.preview === 'setup' && this.setupApps.length <= this.lastItem){
            this.page = 0;
            this.lastItem = 0;
        }
        this._show();
    },

    showPrevious: function () {
        if (this.page !== 0){
            this.lastItem = (this.preview === 'setup') ? this.lastItem - 6 : this.lastItem - 5;
            this.page--;
            this.lastItem = ((!this.webAuthEnabled) && (this.page === 0))  ? this.lastItem - 6 : (this.preview === 'setup') ? this.lastItem - 6 : this.lastItem - 5;
            this._show();
        }
    },
    
    showSetup: function () {
        this.lastItem = 0;
        $('#pageTitle').text('Setup');
        this.preview = 'setup';
        this.page = 0;
        this._show();
    },
    
    show: function () {
        initIndicators();
        this.preview = 'apps';
        this.page = 0;
        getAppConfigs().then(function (apps) {
            if (apps) {
                if (apps.desktopItems) {                        
                    desktopManager.apps = apps.desktopItems.filter(function (obj) {
                        return obj.page;
                    });
                }
                if (apps.setupItems) {
                    desktopManager.setupApps = apps.setupItems;
                }
            }
            isWebAuthEnabled().then(function (isWebAuthEnabled) {
                desktopManager.webAuthEnabled = isWebAuthEnabled;
                desktopManager._show();
            })
        });
    }
};

function getAppConfigs() {
    var deferred = $.Deferred();
    var desktopItems = [], setupItems = [];
    $.ajax({
        type: "get",
        url: '/cgi-bin/platform/desktop-items',
        dataType: "json",
        error: function (request, error) {
            logger.error("Unable to get app configs error = {}", error);
            deferred.reject();
        },
        success: function (response) {
            var applications = response.applications;
            for (var i = 0; i < applications.length; i++) {
                var app = applications[i];
                if(app.desktopItems) {
                    for(var j=0; j < app.desktopItems.length; j++){
                        desktopItems.push({
                            appName: app.name,
                            title: app.desktopItems[j].title,
                            icon: app.desktopItems[j].iconPath,
                            iconPosition: app.desktopItems[j].iconPosition || -1,
                            page: app.desktopItems[j].form
                        });
                    }
                }
                if(app.configPages) {
                    for(var j=0; j < app.configPages.length; j++){
                        setupItems.push({
                            appName: app.name,
                            title: app.configPages[j].title,
                            icon: app.configPages[j].iconPath,
                            iconPosition: app.configPages[j].iconPosition || -1,
                            page: app.configPages[j].form
                        });
                    }
                }
                
            }
            
            desktopItems.sort(function (a, b) {
                return a.title > b.title;
            });
            desktopItems.sort(function (a, b) {
                return b.iconPosition - a.iconPosition;
            });

            setupItems.sort(function (a, b) {
                return a.title > b.title;
            });
            setupItems.sort(function (a, b) {
                return b.iconPosition - a.iconPosition;
            });
            
            deferred.resolve({desktopItems: desktopItems, setupItems: setupItems});
        }
    });
    return deferred.promise();
}

function initIndicators() {

    // lte icon
    setupConditionalImage("ctrl_23", undefined, false, "$network.lte.signal", 
        [
            {
                "name": "luxe6200m_20x20_signalbar0.png",
                "minValue": "0",
                "maxValue": "0",
                "pathCorrection": ""
            }, {
                "name": "luxe6200m_20x20_signalbar1.png",
                "minValue": "1",
                "maxValue": "25",
                "pathCorrection": ""
            }, {
                "name": "luxe6200m_20x20_signalbar2.png",
                "minValue": "26",
                "maxValue": "50",
                "pathCorrection": ""
            }, {
                "name": "luxe6200m_20x20_signalbar3.png",
                "minValue": "51",
                "maxValue": "75",
                "pathCorrection": ""
            }, {
                "name": "luxe6200m_20x20_signalbar4.png",
                "minValue": "76",
                "maxValue": "100",
                "pathCorrection": ""
            }
        ]);
        
    // lte text
    $('[eq-name="lte-text"]').html("LTE");
    var lte_presence = registry.getValue("network.lte.presence");
    function showHideLTE(ltePresence){
        if ( ltePresence === "1" ) {
            $('[eq-name="lte-text"]').show();
            $('[eq-name="lte-signal"]').show();
        } else {
            $('[eq-name="lte-text"]').hide();
            $('[eq-name="lte-signal"]').hide();
        }
    }
    showHideLTE(lte_presence);
    registerForVariable("network.lte.presence", function (oldVal, newVal) {
        showHideLTE(newVal);
    });
            
    // wifi icon
    function checkWiFiPresence(wifiPresence) {
        if (wifiPresence === "1") {
            $('[eq-name="wifi-signal"]').show();
        } else {
            $('[eq-name="wifi-signal"]').hide();
        }
    }
    var wifiPresence = registry.getValue("network.wifi.presence");
    checkWiFiPresence(wifiPresence)
    //subscribe to changes
    registerForVariable("network.wifi.presence", function (oldVal, newVal) {
        checkWiFiPresence(newVal)
    });
    setupConditionalImage("ctrl_21", undefined, false, "$network.wifi.net.signal", 
        [
            {
                "name": "luxe6200m_20x20_wifi-0.png",
                "minValue": "0",
                "maxValue": "0",
                "pathCorrection": ""
            }, {
                "name": "luxe6200m_20x20_wifi-25.png",
                "minValue": "1",
                "maxValue": "25",
                "pathCorrection": ""
            }, {
                "name": "luxe6200m_20x20_wifi-50.png",
                "minValue": "26",
                "maxValue": "50",
                "pathCorrection": ""
            }, {
                "name": "luxe6200m_20x20_wifi-75.png",
                "minValue": "51",
                "maxValue": "75",
                "pathCorrection": ""
            }, {
                "name": "luxe6200m_20x20_wifi-100.png",
                "minValue": "76",
                "maxValue": "100",
                "pathCorrection": ""
            }
        ]);
            
    // battery icon
    setupConditionalImage("ctrl_26", undefined, false, "$power-manager.battery.capacity", 
        [
            {
                "name": "luxe6200m_30x20_batteryh_0.png",
                "maxValue": "0",
                "pathCorrection": ""
            }, {
                "name": "luxe6200m_30x20_batteryh_10.png",
                "minValue": "1",
                "maxValue": "10",
                "pathCorrection": ""
            }, {
                "name": "luxe6200m_30x20_batteryh_20.png",
                "minValue": "11",
                "maxValue": "20",
                "pathCorrection": ""
            }, {
                "name": "luxe6200m_30x20_batteryh_30.png",
                "minValue": "21",
                "maxValue": "30",
                "pathCorrection": ""
            }, {
                "name": "luxe6200m_30x20_batteryh_40.png",
                "minValue": "31",
                "maxValue": "40",
                "pathCorrection": ""
            }, {
                "name": "luxe6200m_30x20_batteryh_50.png",
                "minValue": "41",
                "maxValue": "50",
                "pathCorrection": ""
            }, {
                "name": "luxe6200m_30x20_batteryh_60.png",
                "minValue": "51",
                "maxValue": "60",
                "pathCorrection": ""
            }, {
                "name": "luxe6200m_30x20_batteryh_70.png",
                "minValue": "61",
                "maxValue": "70",
                "pathCorrection": ""
            }, {
                "name": "luxe6200m_30x20_batteryh_80.png",
                "minValue": "71",
                "maxValue": "80",
                "pathCorrection": ""
            }, {
                "name": "luxe6200m_30x20_batteryh_90.png",
                "minValue": "81",
                "maxValue": "90",
                "pathCorrection": ""
            }, {
                "name": "luxe6200m_30x20_batteryh_100.png",
                "minValue": "90",
                "maxValue": "100",
                "pathCorrection": ""
            }, {
                "name": "luxe6200m_30x20_batteryh_none.png",
                "minValue": "101",
                "pathCorrection": ""
            }
        ]);
    // battery percentage
    setBatteryPercentage = function (value) {
        if((value === "n/a") || ((parseInt(value) < 0) || (parseInt(value) > 100))) {
            $('[eq-name="bat-text"]').hide();
            return
        }
        $('[eq-name="bat-text"]').show();
        $('[eq-name="bat-text"]').html(value+"%");
    }
    registerForVariable("power-manager.battery.capacity", function (oldVal, newVal) {
        setBatteryPercentage(newVal);
    });
    setBatteryPercentage(variableGet("power-manager.battery.capacity"));

    // BLE icon
    function changeBLEIcon(icon){
        $('[eq-name="ble"]').children('img').attr('src', icon);
    }
    //initial value
    var blePresence = registry.getValue("network.ble.presence");
    if (blePresence === "0") {
        $('[eq-name="ble"]').hide();
    } else {
        $('[eq-name="ble"]').show();

        var bleEnabled = registry.getValue("network.ble.enable");
        var bleStatus = registry.getValue("network.ble.status");

        function handleBLEStatusChange() {
            if (bleEnabled === "1") {
                switch (bleStatus) {
                    case "idle": {
                        changeBLEIcon('assets/images/Luxe6200_Icons_Bluetooth2a_20px.png');
                        break;
                    }
                    case "advertise": {
                        changeBLEIcon('assets/images/Luxe6200_Icons_Bluetooth2a_20px.png');
                        break;
                    }
                    case "display passkey": {
                        changeBLEIcon('assets/images/Luxe6200_Icons_Bluetooth2a_20px.png');
                        break;
                    }
                    case "connected": {
                        changeBLEIcon('assets/images/Luxe6200_Icons_PAIR2_Bluetooth2a_20px.png');
                        break;
                    }
                    default: {
                        changeBLEIcon('assets/images/Luxe6200_Icons_NO_Bluetooth3b_20px.png');
                        logger.error('handleBLEStatusChangebleStatus bleStatus value="{}" is not valid', bleStatus);
                        break;
                    }
                }
            } else {
                changeBLEIcon('assets/images/Luxe6200_Icons_NO_Bluetooth3b_20px.png');
            }
        }
        handleBLEStatusChange();

        registerForVariable("network.ble.enable", function (oldVal, newVal) {
            bleEnabled = newVal;
            handleBLEStatusChange()
        });
        registerForVariable("network.ble.status", function (oldVal, newVal) {
            bleStatus = newVal;
            handleBLEStatusChange();
        });
    }

    // BOLT icon
    //initial value
    var batteryState = registry.getValue("power-manager.battery.state");
    if ( batteryState === "1" || batteryState === "4") {
        $('[eq-name="bolt"]').show();
    } else {
        $('[eq-name="bolt"]').hide();
    }
    //subscribe to changes
    registerForVariable("power-manager.battery.state", function (oldVal, newVal) {
        if ( newVal === "1" || newVal === "4") {
            $('[eq-name="bolt"]').show();
        } else {
            $('[eq-name="bolt"]').hide();
        }
    });
    
    // logout (close icon)
    // check if enableWebAuth is enabled/disabled and hide icon if needed
    isWebAuthEnabled();
};

function isWebAuthEnabled() {
    var deferred = $.Deferred();
    $.ajax({
        type: "get",
        url: '/cgi-bin/file/get?path=desktop/sfiles/web.xml.lck',
    }).always(function(response) {
        if(!response) {
            deferred.resolve(false);
        } else {
            deferred.resolve(true);
        }
    })
    return deferred.promise();
}

function getLastActionTime() {
    var deferred = $.Deferred();
    $.ajax({
        type: "get",
        url: '/cgi-bin/file/get?path=desktop/files/tmp/lastActionTime',
        dataType: "text",
    }).always(function(response) {
        if(response && response.length && (response.substring(0, 5) != '<?xml')) {
            deferred.resolve(response);
        } else {
            deferred.resolve(false);
        }
    })
    return deferred.promise();
}

function setLastActionTime(payload) {
    var deferred = $.Deferred();
    $.ajax({
        type: "post",
        url: '/cgi-bin/file/put?path=desktop/files/tmp/lastActionTime',
        contentType: 'text/plain',
        data: ""+payload,
        dataType: "text",
    }).always(function(response) {
        if(response) {
            deferred.resolve(response);
        } else {
            deferred.resolve(false);
        }
    })
    return deferred.promise();
}
