function SetapTran( ) {
    //this.onLedSignal;   // Called when LED signal is changed
    //this.onFinished;    // Called when transaction is finished. parameter true - transaction successful, parameter false - transaction failed.
    this.tranInProgress = false;
    this.configTreeId = 0;
    this.outcomeTreeId = 1;

    //////////////////////////////////////////////////////
    // Start of interface part
    //////////////////////////////////////////////////////

    // Subscribe to onLedSignal and onFinished signals
    this.ConnectSignals = function( onLedSignal, onFinished ) {
        this.onLedSignal = onLedSignal;
        this.onFinished = onFinished;
    };
    
    // Cancel transaction if it is in progress
    this.Cancel = function() {
        if( setapTran.tranInProgress ) {
            var result = nfc.stop( true );
            if( result.status !== 0 ) {
                log.error( "stop failed: " + result.status.toString() );
            }
        }
    };

    // Start Setap transaction
    this.Start = function( activationTimeoutMs ) {
        $.get( "config.xml", function( data ) { 
            utils.configtree_Clear( setapTran.configTreeId );
            var status = utils.configtree_LoadXML( setapTran.configTreeId, data );
            if( status !== 0 ) {
                log.error( "configtree_LoadXML failed: " + status.toString() );
                setapTran.TranFailed( );
                return;
            }

            status = utils.configtree_PutIntValue( setapTran.configTreeId, "TIMEOUTS.ACTIVATION", activationTimeoutMs );
            if( status !== 0 ) {
                log.error( "configtree_PutIntValue failed: " + status.toString() );
                setapTran.TranFailed( );
                return;
            }
            
            var result = utils.configtree_ToArray( setapTran.configTreeId );
            if( result.status !== 0 ) {
                log.error( "configtree_ToArray failed: " + result.status.toString() );
                setapTran.TranFailed( );
                return;
            }

            status = nfc.updateConfiguration( result.value );
            if( status !== 0 ) {
                log.error( "updateConfiguration failed: " + status.toString() );
                if( status === 101 ) {
                    log.error( nfc.getLastErrorMessage() );
                }
                setapTran.TranFailed( );
                return;
            }

            status = nfc.start( 1, false );
            if( status !== 0 ) {
                log.error( "start failed: " + status.toString() );
                setapTran.TranFailed( );
                return;
            }

            setapTran.tranInProgress = true;
        }, "text");
    };

    //////////////////////////////////////////////////////
    // End of interface part
    //////////////////////////////////////////////////////
    
    // The function below are for internal use and should not be called from outside this module.
    
    nfc.onOutcomeReady.connect( function() {
        setapTran.tranInProgress = false;

        utils.configtree_Clear( setapTran.outcomeTreeId );

        var result = nfc.stop( true );
        if( result.status === 0 ) 
        {
            var status = utils.configtree_ToTree( setapTran.outcomeTreeId, result.config );
            if( status === 0 )
            {
                result = utils.configtree_GetBinValue( setapTran.outcomeTreeId, "OUTCOME.PLUGINS.SETAP.STATUS" );
                if( result.status == 0 )
                {
                    var s = setapTran.ConvertBinDataToString( result.value );
                    if( 0 == s.localeCompare("00000000") )
                    {
                        setapTran.TranSuccessful( );
                    }
                    else
                    {
                        log.error( "Failed. OUTCOME.PLUGINS.SETAP.STATUS: " + s );
                        setapTran.TranFailed( );
                    }
                }
                else
                {
                    log.error( "Get OUTCOME.PLUGINS.SETAP.STATUS failed. status: " + result.status.toString() );
                    setapTran.TranFailed( );
                }
            }
            else
            {
                log.error( "configtree_ToTree failed: " + status.toString() );
                setapTran.TranFailed( );
            }
        }
        else
        {
            log.error( "stop failed: " + result.status.toString() );
            setapTran.TranFailed( );
        }
    });

    nfc.ledState.connect( function( leds ) {
        if( setapTran.onLedSignal ) setapTran.onLedSignal( leds );
    });

    this.TranSuccessful = function() {
        if( setapTran.onFinished ) setapTran.onFinished( true );
    };
    
    this.TranFailed = function() {
        if( setapTran.onFinished ) setapTran.onFinished( false );
    };

    this.ConvertBinDataToString = function( binData ) {
        var result = "";
        for( var i = 0; i < binData.length; i++ )
        {
            var oneByteAsStr = binData[i].toString(16);
            if( 1 == oneByteAsStr.length )
            {
                oneByteAsStr = '0' + oneByteAsStr;
            }
            result += oneByteAsStr;
        }
        return result;
    };
}

// The single instance of SetapTran object
setapTran = new SetapTran( );
