// GUI
(function(window, document, $, $MQX){
    var logfn;
    if ( typeof log !== 'undefined' && log.error ) {
        logfn = log.error;
    } else if ( typeof console !== 'undefined' && console.log) {
        logfn = console.log;
    } else {
        throw { message: "$gui library error: logging is not available" };
    }

    if ( typeof window.$gui !== 'undefined' ) {
        logfn( "failed to initialize $gui library: already defined" );
        return;
    } else if ( typeof $ === 'undefined' ) {
        logfn( "error: $gui library requires jQuery" );
        return;
    }

    window.$gui = {
        alert: function(type,msg) {
            if ( !msg  ) {
                msg = ( "error" == type ) ? "Congratulations! You broke something.<br/>Please press the button below to continue."
                                          : "Something completed successfully.<br/>Please press the button below to continue.";
            }

            $(".gui-alert").remove();
            $("body").append('<div class=\"gui-alert\" id=\"gui-alert\" ' +
                             'style=\"background: url(\'img/' + type + '.png\');position:absolute;width:100%;height:100%;top:0;left:0;z-index:100;\">' +
                             '<span style="position:absolute;top:120px;display:block;padding: 0 15px;">' +
                                ( msg ? msg : "Congratulations! <br/>You broke something, please press the button below to continue." ) +
                              '<span>' +
                             '</div>');

            setTimeout(function(){
                $(".eqp-button").hide();
                $('#gui-alert').addClass('eqp-button');
                $("#gui-alert").click(function(){
                    $(".eqp-button").show();
                    $(".gui-alert").remove();
                });
                $MQX.restartUI();
            }, 50);
        },
    };

    $(document).ready(function() {
        try {
            $MQX.cancel(function(){
                $(".gui-alert").remove();
                $(".eqp-button").show();
            });
        } catch(e) {
            logfn( '$gui initialization failed: ' + e.message );
        }
    });
}(window, document, $, $MQX));
