#!/bin/bash

clear

if [ -z $1 ]; then
  # App name not provided.
  echo Application pame not provided. Exiting.
  exit
fi

APP_DIR=/home/$1

if [ ! -d "$APP_DIR" ]; then
  # Control will enter here if $DIRECTORY doesn't exist.
  echo Application "$1" does not exist. Exiting.
  exit
fi

echo
echo This util will apply desired file permissions to standard application files for application \"$1\" ...
echo
echo This util will NOT change permissions for user files in $APP_DIR/files/ dir.
echo
echo

read -n 1 -p "Are sure you want to apply desired file permissions to standard app files for app \"$1\" ? Y/N: " userInput
if [ "$userInput" != "Y" ] && [ "$userInput" != "y" ]; then
   echo 
   echo Exiting.
   exit 
fi

echo

APP_USER=u_app_$1
APP_GROUP=gr_app_$1

chown -R $APP_USER:$GROUP_USER $APP_DIR
chmod 0775 $APP_DIR/app.conf
chmod -R 0775 $APP_DIR/bin
chmod -R 0775 $APP_DIR/cgi-bin
chmod 0775 $APP_DIR/files
chmod 0775 $APP_DIR/files/application.json
chmod -R 0775 $APP_DIR/html
chmod -R 0775 $APP_DIR/resources

echo
echo Note that this util did NOT change permissions for user files in $APP_DIR/files/ dir. 
echo Custom file permission may cause subsequent application imports to fail. In that case, examine custom file permissions and act accordingly.
echo 


