#!/bin/bash
LOG=/tmp/sdk.log

APPLICATION="sdk/bin/generateThemeSoftlinks"
HTTP_STATUS=200
ERROR_MESSAGE="Unknown error"

APP_NAME=$1

if [[ -e "/home/$APP_NAME/files/themes.json" ]] ; then
  cd /home/$APP_NAME/html/assets/themes
  numfiles=$(echo ls | wc -w)
  if [ $numfiles -gt 0 ] ; then
  numfiles=0
  for dir in *; do
    rm -f /home/$APP_NAME/html/assets/themes/$dir/media/*
  done
  fi
  jq .themes /home/$APP_NAME/files/themes.json | jq -c '.[]' | while read i; do
    theme_name=$(echo "$i" | jq -r .name)
    theme_media=$(echo "$i" | jq -r .media)
    echo "$theme_media" | jq -c '.[]' | while read j; do
      target_name=$(echo "$j" | jq -r .name)
      linked_to=$(echo "$j" | jq -r .linkedTo)
      linked_to_app=$(echo "$j" | jq -r .application)
      if [ $linked_to_app == "null" ] ;
      then
        linked_to_path=../../../images/$linked_to
      else
        linked_to_path=../../../../../../$linked_to_app/html/assets/images/$linked_to
      fi
      echo "linking $linked_to_path to /home/$APP_NAME/html/assets/themes/$theme_name/media/$target_name" >> $LOG
      mkdir -p /home/$APP_NAME/html/assets/themes/$theme_name/media/
      ln -sf $linked_to_path /home/$APP_NAME/html/assets/themes/$theme_name/media/$target_name
    done
  done
fi