#!/bin/bash

LOG=/tmp/quoin.log
application="quoin/payByCard.cgi"

#
# NAME
#	payByCard.cgi
#
# SYNOPSIS
#	http://ip_address/cgi-bin/quoin/payByCard.cgi?amount=12.34
#		Where amount is the transaction amount (may include the $ sign )
#
# DESCRIPTION
#	For now, this is the old kili demo.cgi with the logging
#	sent to a log file.
#
# RETURNS
#	An XML formatted result is returned to the caller.
#
#	<?xml version="1.0"?>
#	<quoin>
#	  <kili>
#	    <text>$text</text>
#	    <result>$result</result>
#	  </kili>
#	</quoin>
#
#	0 = Approved
#	1 = Failed to start transaction</text>
#	2 = declined
#	3 = Cancelled by User
#	4 = Cancelled, card removed
#	5 = Declined with error
#
returnXML() {
cat <<EOF
<?xml version="1.0"?>
<quoin>
  <splash>
    <text>$text</text>
    <result>$result</result>
  </splash>
</quoin>
EOF
}

APP_NAME=payment
IS_CONTACT_EMV=false

if [ -z "$TERMHOST" ]
then
    TERMHOST="127.0.0.1"
fi

ACGI_BASE_PATH=cgi-bin/$APP_NAME
BASE_URL="http://$TERMHOST/$ACGI_BASE_PATH"

if [[ -z "$1" ]] ; then
  amount='$10.00'
else
  amount="$1"
fi
echo "The transaction amount is $amount" >>$LOG
cents=`echo $amount | sed  's/[$.]//g'`
echo "The amount in cents is $cents" >>$LOG

# Emv.LegacyMSD=0 -- use EMV configuration from EMV_CONF.xml
# Emv.Tag.9F02 -- amount authorized (numeric)
# Emv.Tag.81 -- amount authorized (binary)
# Emv.Tag.9C=00 -- transaction type = Sale
# Emv.Tag.EQ07 -- various automation settings
# EncType=M -- PIN encryption type Master/Session
# mindex -- PIN encryption injected master key ID
# wkey -- PIN encryption Master/Session session (working) key

Emv_LegacyMSD=0
Emv_Tag_9F02=`printf "%012d" $cents`
Emv_Tag_81=`printf "%08x" $cents`
Emv_Tag_9C=00
Emv_Tag_EQ07=BF00
EncType=M
mindex=1
wkey=D85A35712D64465FD85A35712D64465FD85A35712D64465F


show_thank_you()
{
    echo >>$LOG
    echo "Show \"Thank You\" web page" >>$LOG
    curl -s -S 'http://'$TERMHOST'/cgi-bin/page/show?path='$APP_NAME'/info.xhtml&queryString=Message%3DThank%20you!' >/dev/null
}

show_wait()
{
    echo >>$LOG
    echo "Show \"Please Wait\" web page" >>$LOG
    curl -s -S 'http://'$TERMHOST'/cgi-bin/page/show?path='$APP_NAME'/info.xhtml&queryString=Message%3DPlease%20wait...' >/dev/null
}

show_host_comms()
{
    echo >>$LOG
    echo "Show \"Host Comms\" web page" >>$LOG
    curl -s -S 'http://'$TERMHOST'/cgi-bin/page/show?path='$APP_NAME'/info.xhtml&queryString=Message%3DHost%20comms' >/dev/null
}

show_approved()
{
    echo >>$LOG
    echo "Show \"Approved\" web page" >>$LOG
    curl -s -S 'http://'$TERMHOST'/cgi-bin/page/show?path='$APP_NAME'/info.xhtml&queryString=Message%3DApproved' >/dev/null
}

show_declined()
{
    echo >>$LOG
    echo "Show \"Declined\" web page" >>$LOG
    curl -s -S 'http://'$TERMHOST'/cgi-bin/page/show?path='$APP_NAME'/info.xhtml&queryString=Message%3DDeclined' >/dev/null
}

show_cancelled()
{
    echo >>$LOG
    echo "Show \"Cancelled\" web page" >>$LOG
    curl -s -S 'http://'$TERMHOST'/cgi-bin/page/show?path='$APP_NAME'/info.xhtml&queryString=Message%3DCancelled' >/dev/null
}

send_request()
{
    URL="$BASE_URL/$1"

    Emv_Status=
    Emv_Step=

    echo >>$LOG
    echo "send_request()" >>$LOG
    echo "==============" >>$LOG
    echo "curl -s -S $URL" >>$LOG
    echo "response is:" >>$LOG
    local IFS=$'\n'
    for line in $(curl -s -S "$URL")
    do
	if echo "$line" | grep -q '='
        then
            variable_name="$(echo "$line" | cut -d '=' -f 1 | sed -r 's/\./_/g')"
            variable_value="$(echo "$line" | cut -d '=' -f 2-)"
            eval "$variable_name='$variable_value'"
        fi
	echo "    $line" >>$LOG
    done
}

process_event()
{
    echo >>$LOG
    echo "process_event()" >>$LOG
    echo "===============" >>$LOG
    echo "Emv_Step   = '$Emv_Step'" >>$LOG
    echo "Emv_Status = '$Emv_Status'" >>$LOG

    case "$Emv_Step" in
        "MSR")
            echo "Event = Magnetic Stripe card swiped or Contactless Legacy MSD mode tap" >>$LOG
            ;;

        "StartEmv")
            echo "Event = StartEMV" >>$LOG
            IS_CONTACT_EMV=true
            ;;

        "ContinueEmv")
            ;;

        "CompleteEmv")
            echo "Event = After-online processing completed" >>$LOG
            ;;

        "CLMSD")
            echo "Event = Contactless card tapped. MSD mode." >>$LOG
            ;;

        "CLEMV")
            echo "Event = Contactless card tapped. CHIP mode." >>$LOG
            ;;

        "RemoveCard")
            echo "Event = Contact card was removed." >>$LOG
            ;;
    esac

    case "$Emv_Status" in
        ""|"0")
            case "$Emv_Step" in
                "StartEmv")
                    echo "EMV Step = StartEMV Contact chip card inserted" >>$LOG
                    process_insert
                    ;;

                *)
                    echo "EMV Step = Transaction complete" >>$LOG
                    show_thank_you
                    text="Approved"
                    result=0
                    returnXML
                    ;;
            esac
            ;;

        "1")
            case "$Emv_Step" in
                "StartEmv")
                    echo "Card presentment failed." >>$LOG
                    IS_CONTACT_EMV=false
                    ;;

                *)
                    echo "Transaction completed with an error." >>$LOG
                    ;;
            esac

            wait_for_card_remove
            show_declined
            text='Declined, with error'
            result=5
            returnXML
            ;;

        "25")
            echo "Fallback in progress" >>$LOG
            wait_for_card_remove

            IS_CONTACT_EMV=false
            process_fallback
            text='Declined'
            result=2
            returnXML
            ;;

        "81")
            echo "Transaction cancelled because card was removed" >>$LOG
            show_cancelled
            text='Cancelled, card removed'
            result=4
            returnXML
            ;;

        "85")
            echo "Cancelled by user" >>$LOG
            wait_for_card_remove
            show_cancelled
            text='Cancelled by USer'
            result=3
            returnXML
            ;;

        "128"|"132"|"136"|"140")
            wait_for_card_remove
            echo "Declined" >>$LOG
            show_declined
            text='Declined'
            result=2
            returnXML
            ;;

        "129"|"133"|"137"|"141")
            wait_for_card_remove
            echo "Approved" >>$LOG
            show_approved
            text="Approved"
            result=0
            returnXML
            ;;

        "130"|"134"|"138"|"142")
            echo "On-line comms required" >>$LOG
            process_online
            ;;

        *)
            echo "Emv.Status = $Emv_Status. Assuming failure." >>$LOG
            wait_for_card_remove
            show_declined
            text='Declined'
            result=2
            returnXML
            ;;
    esac
}

process_insert()
{
    echo >>$LOG
    echo "Processing card insertion..." >>$LOG
    echo "============================" >>$LOG
    echo "sending payment/event to set up to receive the next event" >>$LOG
    send_request 'event'
    process_event
}

wait_for_card()
{
    echo >>$LOG
    echo "Waiting for card..." >>$LOG
    echo "===================" >>$LOG
    echo "sending payment/event to set up to receive the next event" >>$LOG
    send_request 'event'
    process_event
}

wait_for_card_remove()
{
    if [ "$IS_CONTACT_EMV" == "true" ]
    then
        echo >>$LOG
        echo "Waiting for card remove..." >>$LOG
        send_request 'event'
        if [ "$Emv_Step" != "RemoveCard" ]
        then
            echo "WARNING!!! Wrong step detected!" >>$LOG
        fi
    fi
}

process_fallback()
{
    echo >>$LOG
    echo "Processing fallback" >>$LOG
    wait_for_card
}

process_online()
{
    echo >>$LOG
    echo "Simulating online comms" >>$LOG
    echo "=======================" >>$LOG
    show_host_comms

    echo "Connecting to host..." >>$LOG
    sleep 1
    echo "Sending message..." >>$LOG
    sleep 1
    echo "Waiting reply..." >>$LOG
    sleep 1

    echo >>$LOG
    echo "Submitting simulated host response" >>$LOG
    show_wait
    send_request 'complete?Emv.Tag.EQ11=00&Emv.Tag.89=313233343536&Emv.Tag.8A=3030&Emv.Tag.91=1234567890ABCDEF'

    echo >>$LOG
    echo "Waiting for after-online processing to complete..." >>$LOG
    send_request 'event'
    process_event
}

echo "Starting transaction with amount of $amount, tran type = Sale..." >>$LOG
echo "Emv.Tag.9F02 = '$Emv_Tag_9F02' and Emv.Tag.81 = '$Emv_Tag_81'" >>$LOG

QUERY_STRING="Emv.LegacyMSD=$Emv_LegacyMSD"
QUERY_STRING="$QUERY_STRING&Emv.Tag.9F02=$Emv_Tag_9F02"
QUERY_STRING="$QUERY_STRING&Emv.Tag.81=$Emv_Tag_81"
QUERY_STRING="$QUERY_STRING&Emv.Tag.9C=$Emv_Tag_9C"
QUERY_STRING="$QUERY_STRING&Emv.Tag.EQ07=$Emv_Tag_EQ07"
QUERY_STRING="$QUERY_STRING&EncType=$EncType"
QUERY_STRING="$QUERY_STRING&mindex=$mindex"
QUERY_STRING="$QUERY_STRING&wkey=$wkey"

send_request "start?$QUERY_STRING"
echo >>$LOG

if [ "$response" != "0" ]
then
    echo "Failed to start transaction" >>$LOG
    text="Failed to start transaction"
    result=1
    returnXML
    exit
fi

echo "Transaction started OK" >>$LOG
wait_for_card

