#!/bin/bash

if [ "$QUERY_STRING" ] ; then
  saveIFS=$IFS
  IFS=\&
  set $QUERY_STRING
  while [ "$1" ] ; do
    left=${1%=*}
    right=${1#*=}
    eval $left=$right
    shift
  done
  IFS=$saveIFS
fi
file=${file%/}
name=${file##*/}

if [[ -e "/home/sdk/files/tmp/$file" ]] ; then
  echo "Content-Type: application/octet-stream"
  echo "Content-Disposition: attachment; filename=\"$name\""
  echo ""
  cat /home/sdk/files/tmp/$file
else
cat << EOF
Content-type: text/html

<!DOCTYPE HTML>
<html>
<head>
  <META NAME="Author" CONTENT="Steve Newall">
  <META NAME="Generator" CONTENT="vi (because real programmers use real editors)">
</head>
<body>
Error, file '$file' doesn't exist
</body>
</html>
EOF
fi
