//--XXXXboundary action script
function errorBeep() {
    setTimeout( function() {
        beepEx( 1, 500, 250, 0 );
    }, 0 );
}
//--XXXXboundary action script
function promptBeep() {
    setTimeout( function() {
        beepEx( 2, 2000, 24, 75 );
    }, 0 );
}
//--XXXXboundary action script
function setMenuVariables( options, variableName, maxOptions ) {
    if ( options === undefined || options === null || options === false ) {
        options = "";
    }
    
    var optionValues = options.split( "," );
    while ( optionValues.length < maxOptions ) {
        optionValues.push( "" );
    }
    for ( var i = 0; i < maxOptions; i++ ) {
        variableSet( variableName + ( i + 1 ), optionValues[ i ] );
    }
    
}
//--XXXXboundary action script
function fireJSONEvent( result, data ) {
    fireEvent( JSON.stringify( {
        "Result": result,
        "Data": data
    }));
}
//--XXXXboundary action script
function setOptionVariables( options, validOptions, variablePrefix, enabledValue ) {
    if ( options === undefined || options === null || options === false ) {
        options = "";
    }
    var specifiedValues = options.split( "," );
    var validValues = validOptions.split( "," );
    
    for ( var i = 0; i < validValues.length; i++ ) {
        var option = validValues[ i ];
        var variableName = variablePrefix + validValues[ i ];
        var variableValue;
        if ( specifiedValues.indexOf( option ) != -1 ) {
            variableValue = enabledValue;
        } else {
            variableValue = "";
        }
        variableSet( variableName, variableValue );
    }
}
//--XXXXboundary action script
function processSignature() {
    var data = getControlValue( "sig" );
    var action = "";
    if ( data.done !== undefined ) {
        action = "enter";
    } else if ( data.clear !== undefined ) {
        action = "clear";
    } else if ( data.button !== undefined ) {
        action = data[ "button" ];
    } else if ( data.timeout !== undefined ) {
        action = "timeout";
    } else if ( data.sig !== undefined ) {
        action = "enter";
    }
    
    var event = {};
    
    switch ( action ) {
        case "enter":
            event[ "Result" ] = "Signed";
            if ( data.sig !== undefined ) {
                event[ "Signature" ] = data.sig;
            }
            break;
        case "cancel":
            event[ "Result" ] = "Cancel";
            break;
        case "timeout":
            event[ "Result" ] = "Timeout";
            break;
        case "clear":
        default:
            return;
    }
    
    fireEvent( JSON.stringify( event ) );
}
//--XXXXboundary action script
function selectMenuFromKeypad( keyCode, menuVar ) {
    // Only consider keys 1 to 9
    switch ( keyCode ) {
        case KeyCode.KP_1:
        case KeyCode.KP_2:
        case KeyCode.KP_3:
        case KeyCode.KP_4:
        case KeyCode.KP_5:
        case KeyCode.KP_6:
        case KeyCode.KP_7:
        case KeyCode.KP_8:
        case KeyCode.KP_9:
            var menuNr = String.fromCharCode( keyCode );
            // If variable prefixed by menuVar and suffixed by the pressed key (1,2,3...) is
            // non-empty, then assume menu item is valid (i.e. visible on the screen) and fire
            // event with event number (which happens to match the pressed key).
            // Example: If "menuVar" is "menu" and pressed key is 2, then we look at registry
            // variable "menu2". If the variable is not empty, then we fireEvent( "2" ).
            // Menu variables shall be pre-set at onBeforeInitPageControls stage by calling
            // setMenuVariables() custom action.
            menuValue = variableGet( menuVar + menuNr )
            if ( ( menuValue !== null ) && ( menuValue != "" ) ) {
                fireEvent( menuNr );
            }
            break;
    }
}
//--XXXXboundary action script
function cancelFromKeypad( keyCode ) {
    fireEventFromKeypad( keyCode, KeyCode.CANCEL, "Cancel" );
}
//--XXXXboundary action script
function confirmFromKeypad( keyCode ) {
    fireEventFromKeypad( keyCode, KeyCode.ENTER, "Enter" );
}
//--XXXXboundary action script
function fireEventFromKeypad( keyCode, expectedKeyCode, event ) {
    if ( keyCode == expectedKeyCode ) {
        fireEvent( event );
    }
}
//--XXXXboundary action script
function actCalcTotal() {
  calcTotal();
}
//--XXXXboundary action script
function Cb1Selected() {
  initCBColors();
  
  var elem = document.getElementsByClassName("SELCASH1");
  elem[0].style.backgroundColor = XSelectColor;
}
//--XXXXboundary action script
function initCBColors() {
    if (XButtonColor == '#' + null) {
        XButtonColor = "#4A25AA";
    }
    
    var elem = document.getElementsByClassName("SELCASH0");
    elem[0].style.backgroundColor = XButtonColor;
    
    elem = document.getElementsByClassName("SELCASH1");
    elem[0].style.backgroundColor = XButtonColor;

    elem = document.getElementsByClassName("SELCASH2");
    elem[0].style.backgroundColor = XButtonColor;

    elem = document.getElementsByClassName("SELCASH3");
    elem[0].style.backgroundColor = XButtonColor;

    elem = document.getElementsByClassName("SELCASH4");
    elem[0].style.backgroundColor = XButtonColor;
}
//--XXXXboundary action script
function Cb2Selected() {
  initCBColors();
  
  var elem = document.getElementsByClassName("SELCASH2");
  elem[0].style.backgroundColor = XSelectColor;
}
//--XXXXboundary action script
function Cb3Selected() {
  initCBColors();
  
  var elem = document.getElementsByClassName("SELCASH3");
  elem[0].style.backgroundColor = XSelectColor;
}
//--XXXXboundary action script
function Cb4Selected() {
  initCBColors();
  
  var elem = document.getElementsByClassName("SELCASH4");
  elem[0].style.backgroundColor = XSelectColor;
}
//--XXXXboundary action script
function Cb0Selected() {
  initCBColors();
  
  var elem = document.getElementsByClassName("SELCASH0");
  elem[0].style.backgroundColor = XSelectColor;
}
//--XXXXboundary action script
function initButtonColors() {
  if (variableGet("ButtonColor") != null) {   
    XButtonColor = '#' + variableGet("ButtonColor");
    changeButtonColor();
  }

  registerForVariable('ButtonColor', function(oldVar, newVar) {
    XButtonColor = '#' + newVar;
    changeButtonColor();
  });
}
//--XXXXboundary action script
function initBannerColors() {
  if (variableGet("BannerColor") != null) {   
    XBannerColor = '#' + variableGet("BannerColor");
    changeBannerColor();
  }
  
  registerForVariable('BannerColor', function(oldVar, newVar) {
    XBannerColor = '#' + newVar;
    changeBannerColor();
  });
}
//--XXXXboundary action script
function changeButtonColor() {
    var i = 0;
    var elem = document.getElementsByClassName("BUTTON");
      for (i = 0; i < elem.length; i++) {
      elem[i].style.backgroundColor = XButtonColor;
    }
}
//--XXXXboundary action script
function changeBannerColor() {
    var i = 0;
    var elem = document.getElementsByClassName("BANNER");
    for (i = 0; i < elem.length; i++) {
      elem[i].style.backgroundColor = XBannerColor;
    }
}
//--XXXXboundary action script
function positionInterfaces() {
  var NFC_OFF = variableGet("InterfaceNFC");  
  var SWIPE_OFF = variableGet("InterfaceMSR");  
  var INSERT_OFF = variableGet("InterfaceSCR"); 
  var getID;  
  var XID;
  
  if (NFC_OFF == "" && INSERT_OFF == "" && SWIPE_OFF != "") {
    getID = getControlByName("Swipe");
    getID[0].style.left = "270px";
  }
  
  if (NFC_OFF == "" && INSERT_OFF != "" && SWIPE_OFF == "") {
    getID = getControlByName("Insert");
    getID[0].style.left = "270px";
  }
}
//--XXXXboundary action script
function setUserVars() {
  variableSet( "DisplayCards", "Visa,Amex,Discover,MasterCard" );
  variableSet( "CardSpace", "50" );
    
    
}
//--XXXXboundary action script
function allowCashBack() {
  var IsCashBackSupported = variableGet("Emv.IsCashBackSupported"); 
  var getID;  
  var XID;

  if ( IsCashBackSupported != 1 ) {
	 getID = getControlByName("cb_msg");
     getID[0].style.left = "1000px";

	 getID = getControlByName("cb_0");
     getID[0].style.left = "1000px";
	 
	 getID = getControlByName("cb_1");
     getID[0].style.left = "1000px";

	 getID = getControlByName("cb_2");
     getID[0].style.left = "1000px";

	 getID = getControlByName("cb_3");
     getID[0].style.left = "1000px";

	 getID = getControlByName("cb_4");
     getID[0].style.left = "1000px";
	 
  }
}
//--XXXXboundary action script
function processCVV( action ) {
    switch ( action )
    {
        case "enter":
            var cvv = getControlValue( "cvv" ).cvv;
            if ( cvv )
            {
                fireJSONEvent( "Entered", cvv );
            }
            break;
            
        case "clear":
            setControlValue( "cvv", "" );
            break;
            
        case "cancel":
            fireEvent( "Cancel" );
            break;
            
        case "bypass":
            fireEvent( "Bypassed" );
            break;
            
        case "timeout":
            fireEvent( "Timeout" );
            break;
    }
}
//--XXXXboundary action script
function variableSetAndFireEventFromKeypad( keyCode, expectedKeyCode, variableName, variableValue, event ) {
    var gotExpectedKeyPress = false;
    
    if ( typeof expectedKeyCode == "string" ) {
        gotExpectedKeyPress = ( keyCode == expectedKeyCode );
    }
    else if ( expectedKeyCode instanceof Array ) {
        gotExpectedKeyPress = ( expectedKeyCode.indexOf( keyCode ) != -1 );
    }
    
    if ( gotExpectedKeyPress ) {
        variableSet( variableName, variableValue );
        fireEvent( event );
    }
}
//--XXXXboundary action script
function doActionIf( condition, action, args )
{
    if ( condition )
    {
        action.apply( undefined, args );
    }
}
//--XXXXboundary action script
function variableSetIfEmpty( variableName, value )
{
    var currentValue = variableGet( variableName );
    if ( ( currentValue === null ) || ( currentValue == "" ) )
    {
        variableSet( variableName, value );
    }
}
//--XXXXboundary action script
function initMessage() {
  registerForVariable('Message', function(oldVar, newVar) {
    if (newVar != "Remove Card") {
        stopTimer("Reminder");
    }
  });    
}
//--XXXXboundary action script
function SetupPageTimeout( timerValue, event, timerName )
{
    var timeoutMS = 1000 * parseInt( timerValue, 10 );
    
    registerTimer( timerName, "onetime", timeoutMS, function() {
        fireEvent( event );
        errorBeep();
    });
    
    startTimer( timerName );
}
//--XXXXboundary action script
function SetTimeoutVariable( globalVariableName, localVariableName, defaultValue )
{
    var timeout = variableGet( globalVariableName );
    if( ( timeout == "" ) || ( timeout === null ) )
    {
        timeout = defaultValue;
    }
    
    variableSet( localVariableName, timeout );
}
//--XXXXboundary action script
function hideCardRemovalMessage()
{
    variableSet("Message", " ");
    stopTimer("Reminder");
}
//--XXXXboundary action script
function clearPINFormControls(message)
{
    variableSet("Message", message);
    variableSet("CashNoVisible", "0");
    variableSet("AllowBypassVisible", "false");
    variableSet("PINEntryBoxVisible", "0");
    variableSet("Cash1Visible", "");
    variableSet("Cash2Visible", "");
    variableSet("Cash3Visible", "");
    variableSet("Cash4Visible", "");
}
//--XXXXboundary action script
function showCardInterfaces( interfaces )
{
    setOptionVariables( interfaces, "MSR,SCR,NFC", "Interface", "1" );
    variableSet( "verticalLines", interfaces ? "1" : "" );
}
//--XXXXboundary action script
function showCardBrands( cardBrands )
{
    // For Display DisplayCards
    var XCardData = 
    [{NAME:"AMEX",       NameID:"Img1",  WIDTH:56}, // get these from AB elements
     {NAME:"APPLEPAY",   NameID:"Img2",  WIDTH:86},
     {NAME:"DISCOVER",   NameID:"Img3",  WIDTH:90},
     {NAME:"GOOGLEPAY",  NameID:"Img4",  WIDTH:85},
     {NAME:"INTERAC",    NameID:"Img5",  WIDTH:55},
     {NAME:"JCB",        NameID:"Img6",  WIDTH:75},
     {NAME:"MASTERCARD", NameID:"Img7",  WIDTH:90},
     {NAME:"SAMSUNGPAY", NameID:"Img8",  WIDTH:55},
     {NAME:"UNIONPAY",   NameID:"Img9",  WIDTH:82},
     {NAME:"VISA",       NameID:"Img10",  WIDTH:87}
    ];
    
    var XMaxCardCount = 10;
    var XDisplayTopStr = "360px";
    var XScreenWidth = 800;
    
    var XDisplayCount = 0;
    var XDisplayNames = [];
    var XDisplayIds = [];
    var XDisplayWidths = [];
    var XDisplayLefts = [];

    function initCards()
    {
        for (var x=0; x < XMaxCardCount; x++) {
            var NameID = XCardData[x].NameID; 
            var getID = getControlByName(NameID);
            getID[0].style.left = "1000px";
        }
    }
    
    function parseEcrCsvStr( CardStr ) {
        if (CardStr === undefined || CardStr === "" || CardStr === null) {
            return;
        }
        
        var cards = CardStr.split(",");
        XDisplayNames.splice( 0, XDisplayNames.length );
        
        for (var x=0; x < cards.length; x++) {
            XDisplayNames.push(cards[x]);
        }
        
        var XDisplayCount = XDisplayNames.length;
        
        if (XDisplayCount == 0) { 
            return;
        } 
        
        if (XDisplayCount > 10) { 
            XDisplayCount = 10;
        } 
        
        for (var x=0; x < XDisplayCount; x++) {
            var CardName = XDisplayNames[x].toUpperCase();
            findCardID(CardName);
        }
        
        function findCardID(CardName) {
            for (var x=0; x < XCardData.length; x++) {
                if (XCardData[x].NAME == CardName) {
                    var NameID = XCardData[x].NameID;
                    var getID = getControlByName(NameID);
                    var XID = getID[0].getAttribute('id');
                    XDisplayIds.push(XID);
                    XDisplayWidths.push(XCardData[x].WIDTH);
                    break; 
                }
            }
        }
    }
    
    function displayCards() {
        var TotalWidth = 0;
        var CardWidth = 0;
        var CardWidthSum = 0;
        var x=0;
        
        var XDisplayCount = XDisplayIds.length;
        
        for (x=0; x < XDisplayCount; x++) { 
            CardWidth = XDisplayWidths[x];
            CardWidthSum += Number(CardWidth);
        }
        
        var Delta10 = 10 * (XDisplayCount + 1);
        
        var XSpace = 10;
        
        if ((CardWidthSum + Delta10) > XScreenWidth) {
            XSpace = 1;
        }
        
        for (x=0; x < XDisplayCount; x++) { 
            CardWidth = XDisplayWidths[x];
            TotalWidth += Number(CardWidth);
            
            if (x < XDisplayCount -1) {
                TotalWidth += Number(XSpace);  // skip last Card Space
            }
        }
        
        var W = XScreenWidth - TotalWidth;
        var XStartSpace = parseInt(W/2,10);
        var NewLeft = XStartSpace;
        
        for (x=0; x < XDisplayCount; x++) {
            var XID = XDisplayIds[x];
            
            XDisplayLefts.push(NewLeft);
            document.getElementById(XID).style.left = NewLeft +"px";
            document.getElementById(XID).style.top = XDisplayTopStr;
            
            NewLeft += XDisplayWidths[x] + XSpace;
        }
    }
    
    initCards();
    parseEcrCsvStr( cardBrands );
    displayCards();
}
//--XXXXboundary action script
function updatePresentCardMessage( message, cardInterfaceVariableName, cardBrandhVariableName )
{
    if ( message === null || message === undefined ) {
        message = "";
    }
    
    if ( updatePresentCardMessage.displayState === undefined )
    {
        updatePresentCardMessage.displayState = {
            hidden: false,
            interfaces: variableGet( cardInterfaceVariableName ),
            brands: variableGet( cardBrandhVariableName )
        }
    }
    
    var displayState = updatePresentCardMessage.displayState;
    
    function HideCardInterfacesAndBrands()
    {
        if ( displayState.hidden === true )
        {
            return;
        }
        
        showCardInterfaces( "" );
        showCardBrands( "" );
        displayState.hidden = true;
    }
    
    function ShowCardInterfacesAndBrands()
    {
        if ( displayState.hidden === false )
        {
            return;
        }
        
        showCardInterfaces( displayState.interfaces );
        showCardBrands( displayState.brands );
        displayState.hidden = false;
    }
    
    function ShowCardsAndBrandsForMessage( message )
    {
        // For "Remove card" message or "See phone instructions" do NOT display card interfaces and card brands.
        // For all other messages do display card interfaces and card brands.
        var fullScreenMessages = [
            "#PE_EMVCL_SeePhnInst",
            "#PE_EMVCL_RemoveCard",
            "#PE_EMVCL_CrdReadOK",
            "#PE_VAS_MobileDeviceLocked",
            "#PE_VAS_NotActivated"
        ];
        
        if ( fullScreenMessages.indexOf( message ) == -1 )
        {
            return true;
        }
        else
        {
            return false;
        }
    }
    
    if ( ShowCardsAndBrandsForMessage( message ) )
    {
        ShowCardInterfacesAndBrands();
    }
    else
    {
        HideCardInterfacesAndBrands();
    }
}
//--XXXXboundary action script
function registerForCVVError()
{
    registerForEvent( "onReturn", "manualCVV2", function ( name, obj, response ) {
        CVVPANErrorProcessing( obj );
    } );
}
//--XXXXboundary action script
function processExpDate( action ) {
    switch ( action )
    {
        case "enter":
            var expDate = getControlValue( "expDate" ).expDate;
            if ( expDate )
            {
                setExpirationDate( expDate );
                fireEvent( expDate );
            }
            break;
            
        case "clear":
            setControlValue( "expDate", "" );
            break;
            
        case "cancel":
            fireEvent( "Cancel" );
            break;
            
        case "timeout":
            fireEvent( "Timeout" );
            break;
    }
}
//--XXXXboundary action script
function processManualPAN( action ) {
    switch ( action )
    {
        case "enter":
            var pan = getControlValue( "pan" ).pan;
            if ( pan )
            {
                fireEvent( JSON.stringify( { "Result": "Entered", "Data": pan } ) );
            }
            break;
            
        case "clear":
            setControlValue( "pan", "" );
            break;
            
        case "cancel":
            fireEvent( "Cancel" );
            break;
            
        case "timeout":
            fireEvent( "Timeout" );
            break;
    }
}
//--XXXXboundary action script
function registerForPANError()
{
    registerForEvent( "onReturn", "manualPAN", function ( name, obj, response ) {
        CVVPANErrorProcessing( obj );
    } );
}
//--XXXXboundary action script
function initSelectInstallmentPlan()
{
    variableSet( "set1", "0" );
    variableSet( "set2", "0" );
    
    const plans = JSON.parse( variableGet( "Plans" ) );
    if ( plans === null )
    {
        return;
    }

    const maxPlanNum = 2;

    const maxPlans = function()
    {
        return ( plans.length > maxPlanNum ) ? maxPlanNum : plans.length;
    }();
    
    for ( var i = 1; i <= maxPlanNum; i++ )
    {
        variableSet( "inst" + i, "" );
        variableSet( "freq" + i, "" );
        variableSet( "fee" + i, "" );
        variableSet( "terms" + i, "" );
    }

    if ( plans.length === 1 )
    {
        variableSet( "set1", "1" );
    }
    else
    {
        variableSet( "set2", "1" );
    }
    
    for ( var i = 1; i <= maxPlans; i++ )
    {
        const plan = plans[ i - 1 ];
        
        const frequencyAbbreviation = function()
        {
            switch ( plan.Frequency.toLowerCase() )
            {
                case "weekly":
                    return "wk.";
            
                case "biweekly":
                    return "bw.";
            
                case "monthly":
                    return "mo.";
            
                default:
                    return "";
            }
        }();
        
        variableSet( "inst" + i, '"$"' + plan.Installment );
        variableSet( "freq" + i, "x " + plan.Number + " " + frequencyAbbreviation );
        
        if ( parseFloat( plan.TotalFee ) > 0 )
        {
            variableSet( "fee" + i, 'Total Fee: "$"' + plan.TotalFee );
        }
        else
        {
            variableSet( "fee" + i, "No Fee" );
        }
        
        variableSet( "terms" + i, plan.Terms );
    }

}
//--XXXXboundary action script
function confirmPlan( n )
{
    variableSet( "Plan", n );
    showPageThroughPaymentEngine( "VIA_InstallmentPlanConfirmation" );
}
//--XXXXboundary action script
function initInstallmentPlanConfirmation()
{
    const n = variableGet( "Plan" );
    
    if ( n === null )
    {
        return;
    }
    
    variableSet( "inst", variableGet( "inst" + n ) );
    variableSet( "freq", variableGet( "freq" + n ) );
    variableSet( "fee", variableGet( "fee" + n ) );
    
    const plans = JSON.parse( variableGet( "Plans" ) );
    if ( plans === null )
    {
        return;
    }
    
    const fee = plans[ n - 1 ].TotalFee;
    var total = parseFloat( variableGet( "Base" ) );
    total += parseFloat( fee );
    
    variableSet( "total", 'Total: \"$\"' + total.toFixed( 2 ) );
}
//--XXXXboundary action script
function showPageThroughPaymentEngine( path )
{
    fireEvent( JSON.stringify( { "Action" : "showPage", "Path": path } ) );
}
//--XXXXboundary action script
function InitInstallmentsConfirmTerms()
{
    const n = variableGet( "Plan" );
    const terms = variableGet( "terms" + n );
    
    scrollableArea.initText( "tc", terms, false );
}
//--XXXXboundary action script
function endInstallmentPlanConfirmation( button )
{
    variableSet( "visible", "0" );
    scrollableArea.setData( "tc", "" );
    
    var message = "";
    var event = "";
    
    switch ( button )
    {
        case "confirm":
            message = "#VIA_Processing";
            event = variableGet( "Plan" );
            break;
            
        case "cancel":
            message = "#VIA_Cancelled";
            event = "Cancel";
            break;
    }
    
    variableSet( "Message", message );
    fireEvent( event );
}
//--XXXXboundary action script
function processInstallmentsInput( response ) {
    function cleanUp( message )
    {
        promptClear();
        variableSet( "visible", "0" );
        variableSet( "Message", message );
    }
    
    switch ( response.button )
    {
        case "enter":
            var extData = getControlValueExt( "input" );
            if ( extData && ( extData.type === "textbox" ) && ( extData.templateMatched === 1 ) )
            {
                cleanUp( "#VIA_Processing" );
                fireEvent( JSON.stringify( { "Result": "Entered", "Data": response.input } ) );
            }
            break;
            
        case "cancel":
            cleanUp( "#VIA_Cancelled" );
            fireEvent( "Cancel" );
            break;
    }
}
//--XXXXboundary action script
function endInstallmentsYesNo( button )
{
    variableSet( "visible", "0" );
    
    var message = "";
    var event = "";
    
    switch ( button )
    {
        case "yes":
            message = "#VIA_Processing";
            event = "Yes";
            break;
            
        case "no":
            message = "#VIA_Processing";
            event = "No";
            break;
            
        case "cancel":
            message = "#VIA_Cancelled";
            event = "Cancel";
            break;
    }
    
    variableSet( "Message", message );
    fireEvent( event );
}
//--XXXXboundary action script
function endInstallmentPlanSelection( button )
{
    variableSet( "visible", "0" );
    variableSet( "set1", "0" );
    variableSet( "set2", "0" );
    
    var message = "";
    var event = "";
    
    switch ( button )
    {
        case "payInFull":
            message = "#PE_Processing";
            event = "PayInFull";
            break;
            
        case "cancel":
            message = "#PE_Cancelled";
            event = "Cancel";
            break;
    }
    
    variableSet( "Message", message );
    fireEvent( event );
}
//--XXXXboundary action script
function SendCustomEvent( name, value )
{
    eventData = '{"' + name + '": "' + value + '"}';
    eventJSON = '{ "Action": "event", "CustomEventData": ' + eventData + '}';
    fireEvent( eventJSON );
}
//--XXXXboundary action script
function SendCustomEventGroup( eventDataJSON )
{
    // eventData should contain correctly formatted JSON object
    eventJSON = '{ "Action": "event", "CustomEventData": ' + JSON.stringify( eventDataJSON ) + '}';
    fireEvent( eventJSON );
}
//--XXXXboundary action script
function showMSRMessageOrError( msrData, msrError ) {
    function hasAnyTracks( data ) {
        for ( var trackId = 1; trackId <= 3; trackId++ ) {
            if ( data[ 'track' + trackId ] || data[ 'track' + trackId + "Encrypted" ] || data[ 'track' + trackId + "Masked" ] ) {
                return true;
            }
        }
        return false;
    }

    function getPromptToDisplay( msrData, msrError ) {
        if ( msrData ) {
            if ( hasAnyTracks( msrData ) ) {
                return "MSR_Processing";
            } else {
                // Compare errorId against P2PE::Status::NoCardRangeFound, which is defined in P2PE_Shared_Const.hpp like this:
                // No matching card range found for given PAN value
                // NoCardRangeFound = 11,
                if ( msrData.hasOwnProperty( "errorCode" ) &&
                     msrData.hasOwnProperty( "subComponentErrorDetails" ) &&
                     msrData.subComponentErrorDetails.hasOwnProperty( "errorId" ) &&
                     ( msrData.errorCode == eqErrors.MSR_GENERAL_ERROR.errorCode ) &&
                     ( msrData.subComponentErrorDetails.errorId == 11 ) ) {
                    
                    return "MSR_NoCardRangeFound";
                } else {
                    return "MSR_CardError";
                }
            }
        } else if ( msrError ) {
            if ( msrError.errorCode != eqErrors.MSR_TRACK_NOT_FOUND.errorCode ) {
                return null; // Not an MSR error
            }
            return "MSR_CardError";        
        } else {
            return null; //
        }
    }

    function getPromptValue( promptName ) {
        if ( !promptName ) {
            return null;
        }
        var promptValue = null;
        var langCode = variableGet( "LanguageCode" );
        if ( langCode ) {
            promptValue = getCurrentAppPrompt( promptName, langCode );
        }
        if ( !promptValue ) {
            promptValue = getCurrentAppDefaultLangPrompt( promptName );
        }
        return promptValue;
    }

    var promptValue = getPromptValue( getPromptToDisplay( msrData, msrError ) );
    if ( !promptValue ) {
        return;
    }

    // Hide SCR, NFC< MSR icons
    variableSet( "InterfaceSCR", "" );
    variableSet( "InterfaceNFC", "" );
    variableSet( "InterfaceMSR", "" );

    // Set MSR prompt
    variableSet( "pinpad.MSRMessage", promptValue );

    // Show MSR prompt
    var elem = document.getElementsByClassName( "TxtMSRMessage" );
    for ( var i = 0; i < elem.length; i++ ) {
        elem[ i ].classList.remove( "hidden" );
    }

    stopTimer( "Timeout" );
}
//--XXXXboundary action script
function stock_sendText( data )
{
    var controlValueExt = getControlValueExt( 'TB1' );

    if ( controlValueExt && ( controlValueExt.templateMatched == 1 ) )
    {
        if ( data !== "" )
        {
            fireEvent( data );
        }
    }
    else
    {
        errorBeep();
    }
}
//--XXXXboundary action script
function stock_onButtonUp()
{
    if ( stock_ProductIdx > 0 )
    {
        stock_ProductIdx -= 1;
        stock_updateItems();
    }
}
//--XXXXboundary action script
function stock_onButtonDown()
{
    if ( stock_ProductIdx < ( stock_List.length  - 1 ) )
    {
        stock_ProductIdx += 1;
        stock_updateItems();
    }
}
//--XXXXboundary action script
function stock_initializeView()
{
    stock_List = [];

    var listJSON = variableGet( "ListJSON" );
    if ( listJSON )
    {
        try
        {
            stock_List = JSON.parse( listJSON );
            stock_ProductIdx = stock_List.length - 1;
        }
        catch( e )
        {}
    }

    var subtotal = variableGet( "slb.subtotal" );
    if ( subtotal )
    {
        $( ".stock_SubtotalValue" ).text( subtotal );
    }

    var tax = variableGet( "slb.tax" );
    if ( tax )
    {
        $( ".stock_TaxValue" ).text( tax );
    }

    var discount = variableGet( "slb.discount" );
    if ( discount )
    {
        $( ".stock_DiscountValue" ).text( discount );
    }

    var total = variableGet( "slb.total" );
    if ( total )
    {
        $( ".stock_TotalValue" ).text( total );
    }

    registerForVariable( "slb.subtotal", function( oldVar, newVar )
    {
        $( ".stock_SubtotalValue" ).text( newVar );
    } );

    registerForVariable( "slb.tax", function( oldVar, newVar )
    {
        $( ".stock_TaxValue" ).text( newVar );
    } );

    registerForVariable( "slb.discount", function( oldVar, newVar )
    {
        $( ".stock_DiscountValue" ).text( newVar );
    } );

    registerForVariable( "slb.total", function( oldVar, newVar )
    {
        $( ".stock_TotalValue" ).text( newVar );
    } );

    stock_updateItems();
}
//--XXXXboundary action script
function stock_initReg()
{
    var newVar;
    newVar =  variableGet( "ListClear" );
    if ( newVar == 1 )
    {
        stock_List = [];
        variableSet( "ListJSON", JSON.stringify( [] ) );

        variableSet( "slb.subtotal", "" );
        variableSet( "slb.tax", "" );
        variableSet( "slb.discount", "" );
        variableSet( "slb.total", "" );

        variableSet( "ListClear","0" );

        stock_updateItems();
    }
}
//--XXXXboundary action script
function stock_listClear()
{
    stock_List = [];
    variableSet( "ListJSON", JSON.stringify( [] ) );
    
    variableSet( "slb.subtotal", "" );
    variableSet( "slb.tax", "" );
    variableSet( "slb.discount", "" );
    variableSet( "slb.total", "" );

    //  variableSet("ListClear","1");

    stock_updateItems();
    variableSet( "amtOn", "0" );
}
//--XXXXboundary action script
function stock_processUpdateItems( data )
{
    var S = data;
    var S1 = S.substring( 2, 5 );

    if ( S1 == "xml" )
    {
        stock_processUpdateItemsFromXML( data );
        return;
    }

    var cmd = JSON.parse( data );
    XCmd = cmd;

    var title = cmd.formTitle;
    var amount = cmd.dollarAmount;

    var clear = cmd.ListClear;
    var description = cmd.description;
    var qty = cmd.qty;
    var price = cmd.price;

    var subtotal = cmd.subtotal;
    var discount = cmd.discount;
    var tax = cmd.tax;
    var total = cmd.total;
    var EcrTotalOn = cmd.EcrTotalOn;

    if ( title !== undefined )
    {
        variableSet( "form.Title", title );
    }

    if ( amount !== undefined )
    {
        variableSet( "dollarAmount", amount );

        if ( amount == "0" || amount === "" )
        {
            variableSet( "amtOn", "0" );
        }
        else
        {
            variableSet( "amtOn", "1" );
        }
    }

    if ( description !== undefined && qty !== undefined  &&  price !== undefined )
    {
        console.log( "Added sale item" );
        // Sale Item
        stock_List.push( { description: description, qty: qty, price: price } );
        stock_ProductIdx = stock_List.length - 1;

        // persist product list 
        variableSet( "ListJSON", JSON.stringify( stock_List ) );
    }

    if ( clear !== undefined )
    {
        variableSet( "ListClear", "1" );
        stock_List = [];
        variableSet( "ListJSON", JSON.stringify( [] ) );
        
        // reset totals
        variableSet( "slb.subtotal", "" );
        variableSet( "slb.tax", "" );
        variableSet( "slb.discount", "" );
        variableSet( "slb.total", "" );

        variableSet( "amtOn", "" );
        variableSet( "form.Title", "" );
    }

    if ( total !== undefined )
    {
        variableSet( "EcrTotalOn", "1" );
        variableSet( "amtOn", "1" );
        //   var $dollarAmount = total;
        variableSet( "dollarAmount", total );
        variableSet( "slb.total", total );
    }

    if ( subtotal !== undefined )
    {     
        var $subtotal = subtotal;
        variableSet( "slb.subtotal", subtotal );
    }

    if ( tax !== undefined )
    {
        var $tax = tax;
        variableSet( "slb.tax", tax );
    }

    if ( discount !== undefined )
    {
        var $discount = discount;
        variableSet( "slb.discount", discount );
    }

    if ( EcrTotalOn !== undefined )
    {
        variableSet( "EcrTotalOn", EcrTotalOn );
    }

    stock_updateItems();
}
//--XXXXboundary action script
function stock_initMenuBtns()
{
    if ( variableGet( "MenuList" ) !== null )
    {
        stock_loadMenuList();  
    }
}
//--XXXXboundary action script
function stock_hideUpDn()
{
    if ( stock_XMenuPtr > 4 )
    {
        variableSet( "PrevOn", "1" ); 
    }
    else
    {      
        variableSet( "PrevOn", "0" );
    }

    if ( stock_XMaxMenuPtr > ( stock_XMenuPtr + 4 ) )
    {
        variableSet( "NextOn", "1" ); 
    }
    else
    {      
        variableSet( "NextOn", "0" );
    }
}
//--XXXXboundary action script
function stock_menuDnBtn()
{
    if ( stock_XMaxMenuPtr < 5 )
    {
        stock_XMenuPtr = 0;
        stock_displayMenuBtns();
        return;
    }

   if ( stock_XMenuPtr > ( stock_XMaxMenuPtr - 5 ) )
   {
        stock_XMenuPtr = 0;
   }
   else
   {
        stock_XMenuPtr += 5;
   }

   stock_displayMenuBtns();
}
//--XXXXboundary action script
function stock_calcEventText( menuNum )
{
    var x = 0;
    var txt = "";
    var menuText = "";

    x = stock_XMenuPtr + parseInt( menuNum, 10 );
    menuText = variableGet( "menu" + menuNum );
    txt = x.toString() + "=" + menuText;
    fireEvent( txt );
}
//--XXXXboundary action script
function stock_menuUpBtn()
{
    if ( stock_XMenuPtr < 4 )
    { 
        stock_XMenuPtr = 0;
    }
    else
    {
        stock_XMenuPtr -= 5;
    }
   
    stock_displayMenuBtns();
}
//--XXXXboundary action script
function stock_SendText_TipPerAmt( data ) {

	    var controlValueExt = getControlValueExt( 'TB1' );
	    if (controlValueExt && ( controlValueExt.templateMatched == 1 ) ) 
	    {
	        if (data !== "") 
	        {
              fireEvent( data );
              variableSet("Per",data);
              variableSet("Dol","1");
	        }
	    }
	     else 
	     {
            errorBeep();
	    }
}
//--XXXXboundary action script
function stock_DisplayPromptNum() {
  var elem;
  var PromptNum = variableGet( "PromptNum" );
  var Val = parseInt( PromptNum, 10 );
   
  for (var x=1; x<10; x++) 
  {
    PromptStr = "PROMPT" + x;
    elem = document.getElementsByClassName( PromptStr );

    if (x == Val) 
    {
      elem[0].style.left = "0px";
    }
    else 
    {
      elem[0].style.left = "1000px";
    }
  }   
}
//--XXXXboundary action script
function stock_CancelFromKeypad( keyCode ) 
{
	if ( keyCode == 27 ) 
	{
        fireEvent( "Cancel" );
        pageShowRelative( CurrentForm() );
    }
}
//--XXXXboundary action script
function stock_RevealElement( id )
{
    document.getElementById( id ).style.visibility = "visible";
}
//--XXXXboundary action script
function SetupScrollableTextFromVariable( scrollAreaName, content, scrollDownOnUpdate )
{
    var translated = Translate( content );
    SetScrollAreaText( translated.text );
    
    translated.variables.forEach( function( varName )
    {
        registerForVariable( varName, function()
        {
            var translated = Translate( content );
            SetScrollAreaText( translated.text );
        });
    });
 
    function SetScrollAreaText( text )
    {
        scrollableArea.initText( scrollAreaName, text, scrollDownOnUpdate === true );
    }
    
    function Translate( text )
    {
        return parsePlaceholderString( "$LanguageCode", text );
    }
}
//--XXXXboundary action script
