window.page_manager = {

    pageList: [
        { path: "zero index entry",
            isPageRequired: function () { return true; }
        },

        { path: "audio/built-in.html",
            isPageRequired: function () { return true; }
        },

        { path: "audio/media.html",
            isPageRequired: function () {
                return tools.getAudioCodecName() == "es8374" ? false : true;
            }
        },

        { path: "audio/audiopay.html",
            isPageRequired: function () {
                var isAudiopaydInstalled = true;
                $.ajax({
                    method: "GET",
                    url: "/cgi-bin/systemconfig/isAudiopaydInstalled",
                    async: false,
                    dataType: "json"
                }).done(function (data) {
                    isAudiopaydInstalled = data.isInstalled; // PHX-4160
                }).fail(function (response) {
                    log.error("Failed to determine Audiopayd installation status");
                });
                return !settings.is6200() && isAudiopaydInstalled;
            }
        }
    ],

    isLastPage: function () {
        var nextRequiredPage = this.getNextRequiredPage(window.location.pathname);

        return nextRequiredPage === "index.html";
    },

    getNextRequiredPage: function () {
        var pageIndex = this.getNextPageIndex(window.location.pathname);
        do {
            if (this.pageList[pageIndex].isPageRequired()) {
                return 0 == pageIndex ? "index.html" : this.pageList[pageIndex].path;
            }
            pageIndex = this.getNextPageIndex(this.pageList[pageIndex].path);
        } while (true);
    },

    getPreviousRequiredPage: function () {
        var pageIndex = this.getPreviousPageIndex(window.location.pathname);
        do {
            if (this.pageList[pageIndex].isPageRequired()) {
                return 0 == pageIndex ? "index.html" : this.pageList[pageIndex].path;
            }
            pageIndex = this.getPreviousPageIndex(this.pageList[pageIndex].path);
        } while (true);
    },

    getNextPageIndex: function (currentPageName) {
        var pageIndex = 0;
        for (; pageIndex < this.pageList.length; pageIndex++) {
            if (-1 != currentPageName.indexOf(this.pageList[pageIndex].path)) {
                break;
            }
        }
        pageIndex++;
        return pageIndex >= this.pageList.length ? 0 : pageIndex;
    },

    getPreviousPageIndex: function (currentPageName) {
        var pageIndex = this.pageList.length - 1;
        for (; pageIndex >= 0; pageIndex--) {
            if (-1 != currentPageName.indexOf(this.pageList[pageIndex].path)) {
                break;
            }
        }
        return pageIndex <= 0 ? 0 : pageIndex - 1;
    }
};
