(function ($) {
    window.settings = {
        appName: "systemconfig",

        showPage: function (pagePath, registryValues) {
            var pageUrl = "//localhost/cgi-bin/page/show?path=" + window.settings.appName + "/" + pagePath;
            if (registryValues === undefined) {
                page.showPage(pageUrl);
            } else {
                page.showPage(pageUrl, registryValues);
            }
        },

        is8500: function () {
            var model = registry.getValue("platform.terminalModelName");
            return "LUXE8500i" == model;
        },

        is6200: function () {
            return !window.settings.is8500();
        }
    };

    var consoleImpl = {},
        usbImpl = {},
        networkImpl = {},
        wifiImpl = {},
        dateTimeImpl = {},
        audioImpl = {},
        powerImpl = {},
        bleImpl = {},
        flashLightImpl = {},
        lteImpl = {},
        logImpl = {};

    window.settings.lte = {
        isEnabled: function (callback) {
            return lteImpl.isEnabled(callback);
        },
        enable: function (arg) {
            return lteImpl.enable(arg);
        },
        getManufacturer: function () {
            return lteImpl.getManufacturer();
        },
        getModel: function () {
            return lteImpl.getModel();
        },
        getRevision: function () {
            return lteImpl.getRevision();
        },
        getImei: function () {
            return lteImpl.getImei();
        },
        getSimIccid: function (callback) {
            return lteImpl.getSimIccid(callback);
        },
        getOperator: function (callback) {
            return lteImpl.getOperator(callback);
        },
        getSignal: function (callback) {
            return lteImpl.getSignal(callback);
        },
        getState: function (callback) {
            return lteImpl.getState(callback);
        },
        getMessage: function () {
            return lteImpl.getMessage();
        },
        getPinCounter: function () {
            return lteImpl.getPinCounter();
        },
        isConnected: function () {
            return lteImpl.isConnected();
        },
        listOperators: function () {
            return lteImpl.listOperators();
        }
    };

    window.settings.flashlight = {
        enable: function (setEnabled) {
            return flashLightImpl.enable(setEnabled);
        },

        isEnabled: function () {
            return flashLightImpl.isEnabled();
        },

        setBrightness: function (value) {
            return flashLightImpl.setBrightness(value);
        },

        getBrightness: function () {
            return flashLightImpl.getBrightness();
        },

        setTimeout: function (value) {
            return flashLightImpl.setTimeout(value);
        },

        getTimeout: function () {
            return flashLightImpl.getTimeout();
        }
    };

    window.settings.audio = {
        setSpeakerVolume: function (volume) {
            audioImpl.setSpeakerVolume(volume);
        },

        setMediaVolume: function (volume) {
            audioImpl.setMediaVolume(volume);
        },

        getSpeakerVolume: function () {
            return audioImpl.getSpeakerVolume();
        },

        getMediaVolume: function () {
            return audioImpl.getMediaVolume();
        }
    };

    window.settings.dateTime = {
        // ex. 5 -> 05
        padWithZero: function (i) {
            return dateTimeImpl.padWithZero(i);
        },

        // raw "01312018" for Dec 31, 2018
        isValidDate: function (raw) {
            return dateTimeImpl.isValidDate(raw);
        },

        // raw "2359" for 23:59
        isValidTime: function (raw) {
            return dateTimeImpl.isValidTime(raw);
        },

        // args.date "MM-dd-YYYY"
        // args.time "14:55"
        // args.success = function()
        // args.fail = function(msg)
        setDateTime: function (args) {
            dateTimeImpl.setDateTime(args);
        }
    };

    window.settings.network = {
        isAvailable: function (iface) {
            return networkImpl.isAvailable(iface);
        },

        // args.success = function()
        // args.fail = function(msg)
        enableDHCP: function (args) {
            networkImpl.enableDHCP(args);
        },

        // args.ip
        // args.gateway
        // args.mask
        // args.dns1
        // args.dns2
        // args.success = function()
        // args.fail = function(msg)
        enableStatic: function (args) {
            networkImpl.enableStatic(args);
        },

        getDHCPServerConfig: function () {
            return networkImpl.getDHCPServerConfig();
        },

        getIP: function (iface) {
            return networkImpl.getIP(iface);
        },

        getMask: function (iface) {
            return networkImpl.getMask(iface);
        },

        getDNS1: function (iface) {
            return networkImpl.getDNS1(iface);
        },

        getDNS2: function (iface) {
            return networkImpl.getDNS2(iface);
        },

        getGateway: function (iface) {
            return networkImpl.getGateway(iface);
        },

        isDHCPServerRunning: function () {
            return networkImpl.isDHCPServerRunning();
        },

        enableHTTPS: function (args) {
            return networkImpl.enableHTTPS(args);
        },

        getHttpProto: function (args) {
            networkImpl.getHttpProto(args);
        }
    };

    window.settings.usb = {
        setMode: function (args) {
            // args.mode = newMode
            // args.success = function(mode)
            // args.fail = function(msg)
            usbImpl.setMode(args);
        }
    };

    window.settings.console = {
        // args.success = function(isEnabled)
        // args.fail = function(msg)
        getEnabled: function (args) {
            consoleImpl.getEnabled(args);
        },

        // args.enable = bool
        // args.success = function()
        // args.fail = function(msg)
        setEnabled: function (args) {
            consoleImpl.setEnabled(args);
        }
    };

    window.settings.power = {
        getBrightness: function (args) {
            powerImpl.getBrightness(args);
        },
        setLcdBrightness: function (args) {
            powerImpl.setLcdBrightness(args);
        },
        setKeypadBrightness: function (args) {
            powerImpl.setKeypadBrightness(args);
        },
        getInactivityTimeout: function (args) {
            powerImpl.getInactivityTimeout(args);
        },
        setInactivityTimeout: function (args) {
            powerImpl.setInactivityTimeout(args);
        },
        getSleepMode: function (args) {
            powerImpl.getSleepMode(args);
        },
        setSleepMode: function (args) {
            powerImpl.setSleepMode(args);
        }
    };

    window.settings.wifi = {
        isAvailable: function () {
            return wifiImpl.isAvailable();
        },

        getWowlanStatus: function () {
            return wifiImpl.getWowlanStatus();
        },

        setWowlanStatus: function (args) {
            return wifiImpl.setWowlanStatus(args);
        },

        getNetworkInterfaces: function (callback) {
            wifiImpl.getNetworkInterfaces(callback);
        },

        getWifiNetworks: function (callback) {
            wifiImpl.getWifiNetworks(callback);
        },

        getWifiHeartBeat: function () {
            return wifiImpl.getWifiHeartBeat();
        },
        getBlackListCleanup: function () {
            return wifiImpl.getBlackListCleanup();
        },
        setBlackListCleanup: function (args) {
            return wifiImpl.setBlackListCleanup(args);
        },
        forgetNetwork: function () {
            wifiImpl.forgetNetwork();
        },

        getConfiguredSSID: function () {
            return wifiImpl.getConfiguredSSID();
        },
        /**
            {
                ssid: "",
                psk: "",
                dhcp: 0, // 1 or 0
                ip: "",
                gateway: "",
                mask: "",
                dns1: "",
                dns2: ""
            }
        */
        setWifiConfig: function (wificonfig) {
            return wifiImpl.setWifiConfig(wificonfig);
        },

        connectWifi: function (callback) {
            wifiImpl.connectWifi(callback);
        },

        disconnectWifi: function () {
            return wifiImpl.disconnectWifi();
        },

        getActiveWifiConnection: function () {
            return wifiImpl.getActiveWifiConnection();
        },

        setWifiHeartBeat: function (args) {
            wifiImpl.setWifiHeartBeat(args);
        }

    };

    window.settings.ble = {
        isEnabled: function (callback) {
            return bleImpl.isEnabled(callback);
        },
        enableBLE: function (arg) {
            return bleImpl.enableBLE(arg);
        },
        getControllerName: function () {
            return bleImpl.getControllerName();
        },
        getControllerId: function () {
            return bleImpl.getControllerId();
        },
        getAgent: function () {
            return bleImpl.getAgent();
        },
        getMACAddress: function () {
            return bleImpl.getMACAddress();
        },
        getConnectedMac: function () {
            return bleImpl.getConnectedMac();
        },
        getConnectedSec: function () {
            return bleImpl.getConnectedSec();
        },
        getBondedDevices: function () {
            return bleImpl.getBondedDevices();
        },
        removeBondedByIndex: function (arg) {
            return bleImpl.removeBondedByIndex(arg);
        },
        startBonding: function () {
            return bleImpl.startBonding();
        },
        stopBonding: function () {
            return bleImpl.stopBonding();
        },
        onPasskey: function (callback) {
            return bleImpl.onPasskey(callback);
        },
        waitWhenReady: function (arg) {
            return bleImpl.waitWhenReady(arg);
        },
        onBleReady: function (callback) {
            return bleImpl.onBleReady(callback);
        },
        blePresence: function () {
            return bleImpl.blePresence();
        },
        bleReady: function () {
            return bleImpl.bleReady();
        },
        setJumpPage: function (arg) {
            return bleImpl.setJumpPage(arg);
        },
        getJumpPage: function (arg) {
            return bleImpl.getJumpPage();
        },
        onConnect: function (arg) {
            return bleImpl.onConnect(arg);
        }
    };

    window.settings.log = {
        getApplepayLogPriority: function () {
            return logImpl.getLogPriority("%platform.applepay.logpriority");
        },
        setApplepayLogPriority: function (value) {
            return logImpl.setLogPriority("%platform.applepay.logpriority", value);
        },
        getAndroidpayLogPriority: function () {
            return logImpl.getLogPriority("%platform.androidpay.logpriority");
        },
        setAndroidpayLogPriority: function (value) {
            return logImpl.setLogPriority("%platform.androidpay.logpriority", value);
        }
    };

    // wifi impl
    (function () {
        wifiImpl = {
            scan: 0,
            connect: 0,
            connectTimeoutId: 0,

            callback: null,
            scanCallback: null,

            scanKey: 'network.wifi.scan',
            stateKey: 'network.wifi.net.state'
        };

        wifiImpl.isAvailable = function () {
            return "1" == registry.getValue("network.wifi.presence");
        };

        wifiImpl.getWowlanStatus = function () {
            var res = registry.getValue("%network.wifi.phy.wakeup_on_magic");
            if (res == null) {
                res = 1;
            }
            return res;
        };

        wifiImpl.setWowlanStatus = function (args) {
            registry.setValue("%network.wifi.phy.wakeup_on_magic", args);
        };

        wifiImpl.getNetworkInterfaces = function (callback) {
            var xhttp = new XMLHttpRequest();
            xhttp.onreadystatechange = function () {
                try {
                    if (this.readyState != 4 || this.status != 200) {
                        return;
                    }

                    var data = JSON.parse(this.responseText);
                    callback(data);
                } catch (e) {
                    console.log('getNetworkInterfaces failed: ' + e.message);
                }
            };
            xhttp.open("GET", "/cgi-bin/platform/netinfo", true);
            xhttp.send();
        };

        wifiImpl.getWifiNetworks = function (callback) {
            registry.subscribe(wifiImpl.scanKey);
            wifiImpl.scan = 1;
            wifiImpl.callback = callback;
            registry.setValue(wifiImpl.scanKey, 'start');
        };

        wifiImpl.getWifiHeartBeat = function () {
            return registry.getValue("%network.wifi.net.0.heartbeat");
        };
        wifiImpl.setWifiHeartBeat = function (args) {
            registry.setValue("%network.wifi.net.0.heartbeat", args);
        };

        wifiImpl.getBlackListCleanup = function () {
            return registry.getValue("%network.wifi.net.0.blacklist_cleanup");
        };
        wifiImpl.setBlackListCleanup = function (args) {
            registry.setValue("%network.wifi.net.0.blacklist_cleanup", args);
        };

        wifiImpl.forgetNetwork = function () {
            registry.deleteKey('%network.wifi.net.0.*');
        };

        wifiImpl.getConfiguredSSID = function () {
            return registry.getValue('%network.wifi.net.0.ssid');
        };

        wifiImpl.setWifiConfig = function (wificonfig) {
            var res;
            var heartbeat = registry.getValue("%network.wifi.net.0.heartbeat");
            var blacklistcleanup = registry.getValue("%network.wifi.net.0.blacklist_cleanup");
            res = registry.deleteKey('%network.wifi.net.0.bgscan') === false;
            res |= registry.deleteKey('%network.wifi.net.0.heartbeat') === false;
            res |= registry.deleteKey('%network.wifi.net.0.blacklist_cleanup') === false;
            res |= registry.deleteKey('%network.wifi.net.0.ssid') === false;
            res |= registry.deleteKey('%network.wifi.net.0.tcp.*') === false;

            res |= registry.setValue('%network.wifi.net.0.ssid', wificonfig.ssid) === false;
            if (wificonfig.psk != null) {
                res |= registry.setValue('%network.wifi.net.0.psk', wificonfig.psk) === false;
            }
            res |= registry.setValue('%network.wifi.net.0.tcp.dhcp', wificonfig.dhcp) === false;

            if (wificonfig.dhcp === 0) {
                res |= registry.setValue('%network.wifi.net.0.tcp.ip', wificonfig.ip) === false;
                res |= registry.setValue('%network.wifi.net.0.tcp.gateway', wificonfig.gateway) === false;
                res |= registry.setValue('%network.wifi.net.0.tcp.mask', wificonfig.mask) === false;
                res |= registry.setValue('%network.wifi.net.0.tcp.dns1', wificonfig.dns1) === false;
                res |= registry.setValue('%network.wifi.net.0.tcp.dns2', wificonfig.dns2) === false;
            }

            res |= registry.setValue('%network.wifi.net.0.bgscan', 'simple:2:-72:60');
            res |= registry.setValue('%network.wifi.net.0.heartbeat', heartbeat);
            res |= registry.setValue('%network.wifi.net.0.blacklist_cleanup', blacklistcleanup);

            return res;
        };

        wifiImpl.connectWifi = function (callback) {
            wifiImpl.connectTimeoutId = setTimeout(
                function () {
                    wifiImpl.connectTimeoutId = 0;
                    wifiImpl.connect = 0;
                    registry.unsubscribe(wifiImpl.stateKey);
                    registry.deleteKey('network.wifi.net.connect');
                    var msg = registry.getValue('network.wifi.status');
                    wifiImpl.scanCallback(msg ? "error: " + msg : 'failed to connect (unknown error)');
                }, 20000);
            registry.subscribe(wifiImpl.stateKey);
            wifiImpl.connect = 1;
            wifiImpl.scanCallback = callback;
            registry.deleteKey('network.wifi.net.connect');
            registry.setValue('network.wifi.net.connect', 0);
        };

        wifiImpl.disconnectWifi = function () {
            return false !== registry.deleteKey('network.wifi.net.connect');
        };

        wifiImpl.getActiveWifiConnection = function () {
            return registry.getValue('network.wifi.net.active');
        };

        wifiImpl.connectCallBack = function (key, val) {
            if (!wifiImpl.connect) {
                return;
            }
            if (wifiImpl.stateKey != key) {
                return;
            }

            if ('completed' != val) {
                return;
            }

            if (wifiImpl.connectTimeoutId) {
                clearTimeout(wifiImpl.connectTimeoutId);
                wifiImpl.connectTimeoutId = 0;
            }

            wifiImpl.scanCallback("connected"); // success

            wifiImpl.connect = 0;
            registry.unsubscribe(wifiImpl.stateKey);
        };

        wifiImpl.listCallback = function (key, val) {
            if (!wifiImpl.scan) {
                return;
            }
            if (wifiImpl.scanKey != key || 'idle' != val) {
                return;
            }

            registry.unsubscribe(wifiImpl.scanKey);
            wifiImpl.scan = 0;

            if (!wifiImpl.callback) {
                return;
            }

            var networks = [];
            var n = 0;
            while (n < 99) {
                var bsid = registry.getValue('network.wifi.bss.' + n + '.bssid');
                if (!bsid) {
                    break;
                }

                var ssid = registry.getValue('network.wifi.bss.' + n + '.ssid');
                if (ssid && ssid.trim()) {
                    var pci = registry.getValue('network.wifi.bss.' + n + '.pci');
                    networks.push({
                        ssid: ssid,
                        pciCompatible: ("1" === pci)
                    });
                }
                n++;
            }

            var compare = function (a, b) {
                if (a.ssid > b.ssid) { return 1; }
                if (a.ssid < b.ssid) { return -1; }
                return 0;
            };
            wifiImpl.callback(networks.sort(compare).filter(function (e, i, a) {
                return i === a.map(function (el) { return el.ssid; }).indexOf(e.ssid);
            })); // remove duplicates
        };
        registry.valueChanged.connect(wifiImpl.listCallback);
        registry.valueChanged.connect(wifiImpl.connectCallBack);
    })();

    // audio impl
    (function () {
        audioImpl.setSpeakerVolume = function (v) {
            return tools.setSpeakerVolume(v);
        };

        audioImpl.setMediaVolume = function (v) {
            return tools.setMediaVolume(v);
        };

        audioImpl.getSpeakerVolume = function () {
            return tools.getSpeakerVolume();
        };

        audioImpl.getMediaVolume = function () {
            return tools.getMediaVolume();
        };
    })();

    // dateTime impl
    (function () {
        dateTimeImpl.padWithZero = function (i) {
            if (0 <= i && i <= 9) {
                return '0' + i.toString();
            }
            return i.toString();
        };

        dateTimeImpl.isValidDate = function (raw) {
            if (raw.length < 8) {
                return false;
            }

            var day = raw.substring(2, 4);
            var month = raw.substring(0, 2);
            var year = raw.substring(4, 8);
            var d = new Date(year, month - 1, day, 0, 0, 0, 0);
            return (!isNaN(d) && (d.getDate() == day && d.getMonth() + 1 == month && d.getYear() + 1900 == year));
        };

        dateTimeImpl.isValidTime = function (raw) {
            if (raw.length < 4) {
                return false;
            }

            var hour = raw.substring(0, 2);
            var min = raw.substring(2, 4);
            return (hour < 24 && min < 60);
        };

        dateTimeImpl.setDateTime = function (args) {
            var parts = args.date.split("/");
            var userDateTime = parts[2] + '-' +
                parts[0] + '-' +
                parts[1] + ' ' +
                args.time + ":00";
            var status = tools.setSystemTime(userDateTime);
            if (status) {
                args.fail(status);
                return;
            }

            args.success();
        };
    })();

    // networkImpl
    (function () {
        networkImpl = {
            defEth: function () {
                if (typeof registry.getValue("network.eth1.tcp.running") == "string") {
                    return "eth1";
                }
                return "eth0";
            }(),

            isAvailable: function (iface) {
                return "1" == registry.getValue("network." + iface + ".presence");
            },

            getNetParam: function (iface, what) {
                var ifaceName = iface !== "usb" ? networkImpl.defEth : "usb0";
                var val = registry.getValue("network." + ifaceName + ".tcp." + what);
                if (null === val) {
                    val = registry.getValue("%network." + iface + ".net.tcp." + what);
                }
                return val;
            },

            getIP: function (iface) {
                return networkImpl.getNetParam(iface, "ip");
            },

            getMask: function (iface) {
                return networkImpl.getNetParam(iface, "mask");
            },

            getDNS1: function (iface) {
                return networkImpl.getNetParam(iface, "dns1");
            },

            getDNS2: function (iface) {
                var dns1 = networkImpl.getNetParam(iface, "dns1");
                var dns2 = networkImpl.getNetParam(iface, "dns2");
                if (dns1 != dns2) {
                    return dns2;
                }
                return "";
            },

            getGateway: function (iface) {
                return networkImpl.getNetParam(iface, "gateway");
            },

            isDHCPServerRunning: function () {
                return registry.getValue("network.usb0.dhcp-server.running") === "1";
            }
        };

        networkImpl.verifyConnection = function (args) {
            var iface = null;
            switch (args.iface) {
            case "usb":
                iface = "usb0";
                break;
            case "wlan":
                iface = "wlan0";
                break;
            default:
                iface = registry.getValue("network.eth1.tcp.mac") ? "eth1" : "eth0";
                break;
            }

            var ipAddr = null;
            if (iface !== "wlan0") {
                // check for error
                var err = registry.getValue("network." + iface + ".status");
                if (err) {
                    args.fail(err);
                    return;
                }
            }

            // check connection status
            var isRunning = registry.getValue("network." + iface + ".tcp.running");
            if (isRunning === "0") {
                args.fail("disconnected");
                return;
            }
            ipAddr = ipAddr || registry.getValue("network." + iface + ".tcp.ip");

            ipAddr = ipAddr || "Not set";
            args.success(iface, ipAddr);
        };

        networkImpl.enableDHCP = function (args) {
            registry.deleteKey("%network." + args.iface + ".net.tcp.*");
            registry.setValue("%network." + args.iface + ".net.tcp.dhcp", "1");
            setTimeout(function () {
                networkImpl.verifyConnection(args);
            }, 15000);
        };

        networkImpl.enableStatic = function (args) {
            var pref = "%network." + args.iface + ".net.tcp.";
            registry.setValue(pref + "ip", args.ip);
            registry.setValue(pref + "mask", args.mask);
            registry.setValue(pref + "gateway", args.gateway);
            registry.setValue(pref + "dns1", args.dns1);
            registry.setValue(pref + "dns2", args.dns2);
            registry.setValue(pref + "dhcp", "0");

            if (args.iface === "usb") {
                networkImpl.configureDHCPServer(args);
            }

            setTimeout(function () {
                networkImpl.verifyConnection(args);
            }, 8000);
        };

        networkImpl.configureDHCPServer = function (args) {
            var pref = "%network.usb.net.dhcp-server.";

            if (args.dhcpServer) {
                registry.setValue(pref + "start-ip", args.dhcpServer.startIp);
                registry.setValue(pref + "end-ip", args.dhcpServer.endIp);
                registry.setValue(pref + "max-leases", args.dhcpServer.maxLeases);
                registry.setValue(pref + "lease-duration", args.dhcpServer.leaseDuration);
            } else {
                registry.deleteKey(pref + "*");
            }
        };

        networkImpl.getDHCPServerConfig = function () {
            var value = function (name) {
                var pref = "%network.usb.net.dhcp-server.";
                return registry.getValue(pref + name) || "";
            };

            return {
                startIp: value("start-ip"),
                endIp: value("end-ip"),
                maxLeases: value("max-leases"),
                leaseDuration: value("lease-duration")
            };
        };

        networkImpl.enableHTTPS = function (args) {
            var proto = (args.https ? "HTTPS" : "HTTP");
            var query = "/cgi-bin/platform/lighttpd-conf?action=set&newconf=" + proto;
            $.get(query, function (data) {
                if (data && data.Status == 0) {
                    args.success(proto);
                } else {
                    args.fail(data ? "error code " + data.Status : "unknown error");
                }
            });
        };

        networkImpl.getHttpProto = function (args) {
            $.get("/cgi-bin/platform/lighttpd-conf?action=get", function (data) {
                if (data && data.Status == 0 && data.Message) {
                    args.success(data.Message);
                } else {
                    args.fail(data && data.Status ? "error code " + data.Status : "unknown error");
                }
            });
        };
    })();

    // usb impl
    (function () {
        usbImpl.setMode = function (args) {
            if (args.mode == "ethernet") {
                registry.setValue("%network.usb.net.tcp.mac", args.uniqueMac ? "1" : "0");
            }
            if (!args.onlyMacUpdate || args.mode != "ethernet") {
                setTimeout(function () {
                    var res = tmcore.usbgadget(args);
                    if (res) {
                        args.fail("USB gadget configuration failed with code " + res);
                        return;
                    }
                    args.success(args.mode);
                }, args.mode == "ethernet" ? 2000 : 0);
            } else {
                args.success(args.mode);
            }
        };
    })();

    // console impl
    (function () {
        consoleImpl.getEnabled = function (args) {
            $.get("/cgi-bin/platform/report_console_status", function (data) {
                if (data && data.Status == 0 && data.Message) {
                    args.success(data.Message == 'yes');
                } else {
                    args.fail('system error');
                }
            });
        };

        consoleImpl.setEnabled = function (args) {
            var cmd = args.enable ? 'enable' : 'disable';
            var data = [];
            data.push({
                "command": cmd
            });

            $.ajax({
                type: 'POST',
                timeout: 100,
                url: "//localhost/cgi-bin/platform/change-console-status",
                data: JSON.stringify(data),
                contentType: "text/json",
                traditional: true,
                async: false,
                success: function (data) {
                    if (data.Response != "Ok") {
                        args.fail("console status change error: " + data.Response);
                        return;
                    }

                    args.success();
                }
            });
        };
    })();

    // Power Management impl
    (function () {
        powerImpl.getBrightness = function (args) {
            var getBrightnessCGI = function () {
                $.get("/cgi-bin/platform/brightness", function (data) {
                    var status = {
                        lcd: 100,
                        keypad: 100
                    };

                    if (data.lcd) {
                        status.lcd = data.lcd;
                    }

                    if (data.keypad) {
                        status.keypad = data.keypad;
                    }

                    args.status(status);
                });
            };
            registry.valueChanged.connect(function (key, value) {
                if (key === "power-manager.battery.capacity" ||
                    key === "power-manager.battery.state") {
                    getBrightnessCGI();
                }
            });
            registry.subscribe("power-manager.battery.capacity");
            registry.subscribe("power-manager.battery.state");
            getBrightnessCGI();
        };

        powerImpl.setLcdBrightness = function (args) {
            var lcdVal = args.value;
            $.get("/cgi-bin/platform/brightness?lcd=" + lcdVal, function (data) {
                args.status(data.status || -1);
            });
        };

        powerImpl.setKeypadBrightness = function (args) {
            var keypadVal = args.value;
            $.get("/cgi-bin/platform/brightness?keypad=" + keypadVal, function (data) {
                args.status(data.status || -1);
            });
        };

        var inactivityTimeoutRegKey = "%systemconfig.inactivity_timeout";

        powerImpl.getInactivityTimeout = function (args) {
            var value = registry.getValue(inactivityTimeoutRegKey);
            args.status(+value || 0);
        };

        powerImpl.setInactivityTimeout = function (args) {
            registry.setValue(inactivityTimeoutRegKey, args.value);
        };

        var sleepModeRegKey = "%platform.sleepMode";

        powerImpl.getSleepMode = function (args) {
            var value = registry.getValue(sleepModeRegKey);
            args.status(value || "full sleep");
        };

        powerImpl.setSleepMode = function (args) {
            registry.setValue(sleepModeRegKey, args.value);
        };
    })();

    // bleImpl
    (function () {
        bleImpl.callback = null;
        bleImpl.passKeyCallback = null;
        bleImpl.readyCallback = null;
        bleImpl.jumpPage = null;
        bleImpl.connectionInfoUpdateCallback = null;

        bleImpl.valueChnaged = function (key, value) {
            if (key == "network.ble.enable" && bleImpl.callback != null) {
                if (value == "1") {
                    bleImpl.callback(true);
                } else if (value == "0" || value == "-1") {
                    bleImpl.callback(false);
                }
            }
        };
        bleImpl.isEnabled = function (callback) {
            bleImpl.callback = callback;
            registry.valueChanged.connect(bleImpl.valueChnaged);
            registry.subscribe("network.ble.enable");
            var value = registry.getValue("network.ble.enable");
            if (value == "1") {
                return true;
            }
            return false;
        };

        bleImpl.enableBLE = function (arg) {
            setTimeout(function () {
                if (arg == true) {
                    registry.setValue("%network.ble.autostart", "1");
                    registry.setValue("network.ble.enable", "1");
                } else {
                    registry.setValue("%network.ble.autostart", "0");
                    registry.setValue("network.ble.enable", "0");
                }
            }, 0);
        };

        bleImpl.getControllerName = function () {
            var retVal = registry.getValue("network.ble.controller.info");
            if (retVal == null) {
                return "";
            }
            return retVal;
        };

        bleImpl.getControllerId = function () {
            return registry.getValue("network.ble.controller");
        };
        bleImpl.getAgent = function () {
            return registry.getValue("network.ble.agent");
        };
        bleImpl.getMACAddress = function () {
            var retVal = registry.getValue("network.ble.mac");
            if (retVal == null) {
                return "";
            }
            return retVal;
        };
        bleImpl.getConnectedMac = function () {
            var retVal = registry.getValue("network.ble.connection.mac");
            if (retVal == null) {
                return "";
            }
            return retVal;
        };
        bleImpl.getConnectedSec = function () {
            var retVal = registry.getValue("network.ble.connection.sec");
            if (retVal == null) {
                return "";
            }
            return retVal;
        };

        bleImpl.getBondedDevices = function () {
            var retVal = [];
            var bondedKeys = registry.getKeys("network.ble.bonded.*");
            if (bondedKeys) {
                var regEx = /network.ble.bonded.([0-9]*).mac/;
                for (var i = 0; i < bondedKeys.length; i++) {
                    var matchVal = bondedKeys[i].match(regEx);
                    if (matchVal) {
                        retVal[matchVal[1]] = registry.getValue(bondedKeys[i]);
                    }

                }
            }
            return retVal;
        };

        bleImpl.removeBondedByIndex = function (arg) {
            var keysToRemove = "network.ble.bonded." + arg + ".*";
            registry.deleteKey(keysToRemove);
        };
        bleImpl.startBonding = function () {
            registry.setValue("network.ble.advertise.enable", "1");
            registry.setValue("network.ble.bondable", "1");
        };
        bleImpl.stopBonding = function () {
            registry.setValue("network.ble.bondable", "0");
        };
        bleImpl.passkeyReady = function (key, value) {
            if (key == "network.ble.connection.passkey" && bleImpl.passKeyCallback != null) {
                bleImpl.passKeyCallback(value);
            }
        };
        bleImpl.passkeyRemoved = function (key) {
            if (bleImpl.passKeyCallback != null) {
                bleImpl.passKeyCallback("");
            }
        };
        bleImpl.onPasskey = function (callback) {
            bleImpl.passKeyCallback = callback;
            registry.valueChanged.connect(bleImpl.passkeyReady);
            registry.keyDeleted.connect(bleImpl.passkeyRemoved);

            registry.subscribe("network.ble.connection.passkey");
        };
        bleImpl.waitWhenReady = function (arg) {
            var present = registry.getValue("network.ble.presence");
            var ready = registry.getValue("network.ble.ready");
            if ((present == null || ready == null) || (present == "0" || ready == "0")) {
                page.showPage("//localhost/cgi-bin/page/show?path=" +
                    window.settings.appName + "/ble/notready.html&queryString=" + arg);
            }
        };
        bleImpl.onBleReady = function (callback) {
            bleImpl.readyCallback = callback;
            registry.valueChanged.connect(function (key, value) {
                if (key == "network.ble.presence" || key == "network.ble.ready") {
                    bleImpl.readyCallback();
                }
            });
            registry.subscribe("network.ble.presence");
            registry.subscribe("network.ble.ready");
        };

        bleImpl.blePresence = function () {
            var retVal = registry.getValue("network.ble.presence");
            if (retVal == null) {
                return "1";
            }
            return retVal;
        };
        bleImpl.bleReady = function () {
            var retVal = registry.getValue("network.ble.ready");
            if (retVal == null) {
                return "0";
            }
            return retVal;
        };
        bleImpl.setJumpPage = function (arg) {
            bleImpl.jumpPage = arg;
        };
        bleImpl.getJumpPage = function () {
            if (bleImpl.jumpPage == null) {
                return "index.html";
            }
            return bleImpl.jumpPage;
        };

        bleImpl.onConnect = function (callback) {
            var conStr = "network.ble.connection";
            bleImpl.connectionInfoUpdateCallback = callback;
            registry.valueChanged.connect(function (key, value) {
                if (key.substr(0, conStr.length) == conStr && bleImpl.connectionInfoUpdateCallback != null) {
                    var mac = bleImpl.getConnectedMac();
                    var sec = bleImpl.getConnectedSec();
                    bleImpl.connectionInfoUpdateCallback(mac, sec);
                }
            });
            registry.keyDeleted.connect(function (key, value) {
                if (bleImpl.connectionInfoUpdateCallback != null) {
                    var mac = bleImpl.getConnectedMac();
                    var sec = bleImpl.getConnectedSec();
                    bleImpl.connectionInfoUpdateCallback(mac, sec);
                }
            });
            registry.subscribe(conStr + "*");
        };
    })();

    // lteImpl
    (function () {
        lteImpl.callback = null;
        lteImpl.signalUpdateCallback = null;
        lteImpl.signalUpdateIccid = null;
        lteImpl.signalUpdateOperator = null;
        lteImpl.getStateCallback = null;

        lteImpl.passKeyCallback = null;
        lteImpl.readyCallback = null;
        lteImpl.jumpPage = null;
        lteImpl.connectionInfoUpdateCallback = null;

        lteImpl.valueChnaged = function (key, value) {
            if (key == "network.lte.enable" && lteImpl.callback != null) {
                if (value == "1") {
                    lteImpl.callback(true);
                } else {
                    lteImpl.callback(false);
                }
            }
            if (key == "network.lte.signal" && lteImpl.signalUpdateCallback != null) {
                lteImpl.signalUpdateCallback(value);
            } else if (key == "network.lte.sim.iccid" && lteImpl.signalUpdateIccid != null) {
                lteImpl.signalUpdateIccid(value);
            } else if (key == "network.lte.operator" && lteImpl.signalUpdateOperator != null) {
                lteImpl.signalUpdateOperator(value);
            } else if (key == "network.lte.state" && lteImpl.getStateCallback != null) {
                lteImpl.getStateCallback(value);
            }
        };
        lteImpl.isEnabled = function (callback) {
            lteImpl.callback = callback;
            registry.valueChanged.connect(lteImpl.valueChnaged);
            registry.subscribe("network.lte.enable");
            var value = registry.getValue("network.lte.enable");
            if (value == "1") {
                return true;
            }
            return false;
        };

        lteImpl.ensableState = function () {
            var value = registry.getValue("network.lte.enable");
            if (value == "1") {
                return true;
            }
            return false;
        };

        lteImpl.enable = function (arg) {
            setTimeout(function () {
                if (lteImpl.ensableState() != arg) {
                    if (arg == true) {
                        registry.setValue("network.lte.enable", "1");
                    } else {
                        registry.setValue("network.lte.enable", "0");
                    }
                }
            }, 0);
        };

        lteImpl.getManufacturer = function () {
            return registry.getValue("network.lte.hw.manufacturer");
        };

        lteImpl.getModel = function () {
            return registry.getValue("network.lte.hw.model");
        };

        lteImpl.getRevision = function () {
            return registry.getValue("network.lte.hw.revision");
        };

        lteImpl.getImei = function () {
            return registry.getValue("network.lte.hw.imei");
        };

        lteImpl.getSimIccid = function (arg) {
            lteImpl.signalUpdateIccid = arg;
            registry.valueChanged.connect(lteImpl.valueChnaged);
            registry.subscribe("network.lte.sim.iccid");
            return registry.getValue("network.lte.sim.iccid");
        };

        lteImpl.getOperator = function (arg) {
            lteImpl.signalUpdateOperator = arg;
            registry.valueChanged.connect(lteImpl.valueChnaged);
            registry.subscribe("network.lte.operator");
            return registry.getValue("network.lte.operator");
        };

        lteImpl.getSignal = function (arg) {
            lteImpl.signalUpdateCallback = arg;
            registry.valueChanged.connect(lteImpl.valueChnaged);
            registry.subscribe("network.lte.signal");
            return registry.getValue("network.lte.signal");
        };
        lteImpl.getState = function (arg) {
            lteImpl.getStateCallback = arg;
            registry.valueChanged.connect(lteImpl.valueChnaged);
            registry.subscribe("network.lte.state");
            return registry.getValue("network.lte.state");
        };
        lteImpl.getMessage = function () {
            var rv = registry.getValue("network.lte.message");
            // registry.deleteKey("network.lte.message");
            return rv;
        };
        lteImpl.getPinCounter = function () {
            return registry.getValue("network.lte.sim.pin_counter");
        };
        lteImpl.isConnected = function () {
            var rv = registry.getValue("network.lte.connect");
            return rv != null && rv != "";
        };
        lteImpl.listOperators = function () {
            var operators = [];
            var n = 0;
            while (n < 99) {
                var operator = registry.getValue('network.lte.operators.' + n);
                if (!operator) {
                    break;
                }
                operators.push(operator);
                n++;
            }
            return operators;
        };
    })();

    // flashLightImpl
    (function () {
        var checkResult = function (res) {
            if (res < 0) {
                throw {
                    message: 'please see system log'
                };
            }
            return res;
        };

        flashLightImpl.enable = function (setEnabled) {
            var res = tools.flSetEnabled(setEnabled);
            return checkResult(res);
        };

        flashLightImpl.isEnabled = function () {
            var res = tools.flIsEnabled();
            return checkResult(res);
        };

        flashLightImpl.setBrightness = function (value) {
            var res = tools.flSetBrightness(value);
            return checkResult(res);
        };

        flashLightImpl.getBrightness = function () {
            var res = tools.flGetBrightness();
            return checkResult(res);
        };

        flashLightImpl.setTimeout = function (value) {
            var res = tools.flSetShutoffTimeout(value);
            return checkResult(res);
        };

        flashLightImpl.getTimeout = function () {
            var res = tools.flGetShutoffTimeout();
            return checkResult(res);
        };
    })();

    // Log settings impl
    (function () {
        logImpl.getLogPriority = function (key) {
            var value;
            try {
                value = registry.getValue(key);
                value = parseInt(value);
                if (isNaN(value)) { value = 4; }
                if (value > 7) { value = 7; }
                if (value < 0) { value = 0; }
            } catch (e) {
                console.log('getLogPriority failed: ' + e.message);
                value = 4;
            }
            return value;
        };

        logImpl.setLogPriority = function (key, value) {
            try {
                if (value > 7) { value = 7; }
                if (value < 0) { value = 0; }
                registry.setValue(key, value);
            } catch (e) {
                console.log('setLogPriority failed: ' + e.message);
            }
            return value;
        };
    })();

})($);

// session
(function () {
    window.session = window.session || {};

    window.session.path = settings.appName + ".session";

    window.session.set = function (data) {
        registry.setValue(window.session.path, JSON.stringify(data));
    };

    window.session.get = function () {
        return JSON.parse(registry.getValue(window.session.path));
    };
})();
