#!/bin/sh
KEON=/root/sectest/keon

DOTEST=0
if [ "$1" = "--test" ]
then
    DOTEST=1
    shift
fi

if [ "$1" = "" ]
then
KEON_IP="162.223.154.176"
else
KEON_IP="$1"
fi

if [ "$2" = "" ]
then
KEON_PORT="1405"
else
KEON_PORT="$2"
fi

if [ "$3" = "" ]
then
KEON_TIMEOUT="5"
else
KEON_TIMEOUT="$3"
fi

if [[ $DOTEST -eq 1 ]]; then
    nc -w "${KEON_TIMEOUT}" "${KEON_IP}" "${KEON_PORT}"
    exit $?
fi

DEVEL="-----BEGIN CERTIFICATE-----
MIIDqTCCApGgAwIBAgIQMPg+ml8eieV6IdvHfBQksTANBgkqhkiG9w0BAQsFADBg
MQswCQYDVQQGEwJVUzEZMBcGA1UECgwQRXF1aW5veCBQYXltZW50czEUMBIGA1UE
CwwLRGV2ZWxvcG1lbnQxIDAeBgNVBAMMF0VxdWlub3ggSW50ZXJtZWRpYXRlIENB
MB4XDTEyMDEyMDE5MjIwNVoXDTM3MDEwMTA2NTgwMFowXzELMAkGA1UEBhMCVVMx
GTAXBgNVBAoMEEVxdWlub3ggUGF5bWVudHMxFDASBgNVBAsMC0RldmVsb3BtZW50
MR8wHQYDVQQDDBZFcXVpbm94IFBFRCBTaWduaW5nIENBMIIBIjANBgkqhkiG9w0B
AQEFAAOCAQ8AMIIBCgKCAQEAzAg1AxnYT855RjH9KwjjXId6BqsRe11FxM0IRVg6
RslOVUtT5DbNoIRoXvisVsNbLSKJb4u8j+MW/3HFyft7ciATjjWhvzmY4rLjeKdq
XJ6v/eT3EUGUL5WEkJ+KA5ILpebVc0VtLPfo5owlBHL/K/0ke0BbVREXl3+8bYrK
1OLK4htIrHdbvYjn1WPOhCPVSOyDfYI5kCOsx5RFt/9ikXCBkQ5w6aIlILRNZQ2i
A2Z/xas1QY7CGIK2DzYZER7O2xTJsJ78DvGZz/YKwkVqpMUWxWaScCCkYDozFoNo
7tKOg5feLrsm7o4xYqur/V0ap+hNgHvHorsXcqRISShJTQIDAQABo2AwXjAOBgNV
HQ8BAf8EBAMCAYYwDAYDVR0TBAUwAwEB/zAdBgNVHQ4EFgQUlWRQUb59rCNq073a
WpSwzNPaMQgwHwYDVR0jBBgwFoAURUVfME9ZrrceRkP3j6l4QSyJIMkwDQYJKoZI
hvcNAQELBQADggEBAC9ZwzM2n+XoO2rkR1aPGo3nSo+2UEhMtdXpVlzWET5A5zpl
Gp0dhIi5vtKSikR5WLfGe0kg9dCAfD6JFT5vg8BAqfzPwuuTpbNieJQlMzi6Pqe/
RV9I3Pgz0HjvjPfyoI29nz33+U+VKGPxfwkmWDKby7eZjJ+2qeqOMF4xe5jWbSrd
jRyu8v0MRrAJ0Qn5YxvLj5nzM6nb7j3Be8mzrc3xWDt+WuX91A8i6C1zPMKoJs4X
8Hgywlmk1zkDuA5hiM1BfGp5qKHFpf4PY3z1OmgTxx+mPAcUvBWonKwmzbLum1nU
HDP8GRUweFwnmQhqpRVQYgNIFluA+OHId+T9hCM=
-----END CERTIFICATE-----"

update_boot()
{
	if [ ! -s /boot/activation/readme ] ||
	[ ! -s /boot/boot/linux ] || [ ! -s /boot/boot/linux.sig ] ||
	[ ! -s /boot/boot/phoenix.dtb ] || [ ! -s /boot/boot/phoenix.dtb.sig ] ||
	[ ! -s /boot/boot/griffin.dtb ] || [ ! -s /boot/boot/griffin.dtb.sig ] ||
	[ ! -s /boot/boot/secure ] || [ ! -s /boot/boot/secure.sig ] ||
	[ ! -s /boot/boot/sred ] || [ ! -s /boot/boot/sred.sig ] ||
	[ ! -s /boot/boot/resource ] || [ ! -s /boot/boot/resource.sig ] ||
	[ ! -s /boot/boot/keyboard ] || [ ! -s /boot/boot/keyboard.sig ] ||
	[ ! -s /boot/activation/serial ] || 
	[ ! -s /boot/activation/encryption ] ||  
	[ ! -s /boot/activation/encryption.x509 ] ||
	[ ! -s /boot/activation/identity ] ||  
	[ ! -s /boot/activation/identity.x509 ]
	then
		DUMPMNT=$(mktemp -d -p /var/tmp)
		mount -t ramfs -o size=21m ramfs ${DUMPMNT}
		DUMP=${DUMPMNT}/dump
		MNT=$(mktemp -d)
		mkdir -p /boot/activation
		mkdir -p /boot/boot
		LOOPDEV=$(losetup -f)

		nanddump -f  "${DUMP}" "/dev/${1}" && losetup "${LOOPDEV}" "${DUMP}" && mount "${LOOPDEV}" "${MNT}" && cp ${MNT}/activation/* /boot/activation/ && cp ${MNT}/boot/* /boot/boot/ && sync
		losetup -d "${LOOPDEV}" && umount "${MNT}" && umount "${DUMPMNT}" && rm -rf "${MNT}" "${DUMPMNT}" && sync
	fi
}

subject()
{
	# openssl 1.1
	# openssl x509 -in "/boot/activation/${1}.x509" -inform der -subject -noout -nameopt compat | tail -c +9
	# openssl 1.0
	openssl x509 -in "/boot/activation/${1}.x509" -inform der -subject -noout | tail -c +10
}

req()
{
	openssl req -nodes -newkey rsa:2048 -keyout /dev/stdout -subj "$(subject ${1})" 2>/dev/null
}

keon_req()
{
	printf "-----BEGIN IDENTITY-----\n%s\n-----END IDENTITY-----\n-----BEGIN ENCRYPTION-----\n%s\n-----END ENCRYPTION-----" "$(req identity)" "$(req encryption)"
}

update_boot mtd1
update_boot mtd2
KEON_REQUEST=$(mktemp)
keon_req > "$KEON_REQUEST"
KEON_RESPONSE=$(mktemp)


if [ ! -s "$KEON_REQUEST" ]
then
	printf "Unable to create activation request\n"
	exit 1
fi


${KEON} -s "/boot/activation/identity" "/boot/activation/encryption" < "$KEON_REQUEST" | nc -w "${KEON_TIMEOUT}" "${KEON_IP}" "${KEON_PORT}" > "$KEON_RESPONSE"

if [ ! -s "$KEON_RESPONSE" ]
then
	printf "Unable to reach activation server\n"
	exit 1
fi

IDENTITY_X509=$(mktemp)
ENCRYPTION_X509=$(mktemp)

${KEON} -r "$IDENTITY_X509" "$ENCRYPTION_X509" < "$KEON_RESPONSE"

if [ ! -s "$IDENTITY_X509" ] || [ ! -s "$ENCRYPTION_X509" ]
then
	printf "Unable to activate\n"
	exit 1
fi

mv -f "$IDENTITY_X509" "/boot/activation/identity.x509"
mv -f "$ENCRYPTION_X509" "/boot/activation/encryption.x509"

echo "$DEVEL"|openssl x509 -outform der -out /boot/activation/signing.x509

rm "$KEON_REQUEST" "$KEON_RESPONSE"
DEVEL_ISSUER_HASH="$(echo "$DEVEL"|openssl x509 -hash -noout)"

if [ -s /boot/activation/readme ] &&
[ -s /boot/boot/linux ] && [ -s /boot/boot/linux.sig ] &&
[  -s /boot/boot/phoenix.dtb ] && [ -s /boot/boot/phoenix.dtb.sig ] &&
[ -s /boot/boot/griffin.dtb ] && [ -s /boot/boot/griffin.dtb.sig ] &&
[ -s /boot/boot/secure ] && [ -s /boot/boot/secure.sig ] &&
[ -s /boot/boot/sred ] && [ -s /boot/boot/sred.sig ] &&
[ -s /boot/boot/resource ] && [ -s /boot/boot/resource.sig ] &&
[ -s /boot/boot/keyboard ] && [ -s /boot/boot/keyboard.sig ] &&
[ -s /boot/activation/serial ] &&
[ -s /boot/activation/encryption ] && [ -s /boot/activation/encryption.x509 ] &&
[ -s /boot/activation/identity ] && [ -s /boot/activation/identity.x509 ] &&
[ "$(openssl x509 -inform der -in /boot/activation/identity.x509 -issuer_hash -noout)" = "${DEVEL_ISSUER_HASH}" ] &&
[ "$(openssl x509 -inform der -in /boot/activation/encryption.x509 -issuer_hash -noout)" = "${DEVEL_ISSUER_HASH}" ]
then
#this will update boot partition if sanity check is positive
ROMFSMNT=$(mktemp -d -p /var/tmp)
mount -t ramfs -o size=21m ramfs ${ROMFSMNT}

if genromfs -f "${ROMFSMNT}/romfs" -d /boot 
then
	flash_erase /dev/mtd1 0 0 &> /dev/null && nandwrite -p /dev/mtd1 "${ROMFSMNT}/romfs" &> /dev/null
	flash_erase /dev/mtd2 0 0 &> /dev/null && nandwrite -p /dev/mtd2 "${ROMFSMNT}/romfs" &> /dev/null
fi

if [ -s /etc/platform/sys/identity.x509 ] || [ -s /etc/platform/sys/signing.x509 ]
then
	chattr -i /etc/platform/sys/identity.x509
	chattr -i /etc/platform/sys/signing.x509
	chmod 644 /etc/platform/sys/identity.x509 /etc/platform/sys/signing.x509
fi

cp -f /boot/activation/identity.x509 /etc/platform/sys/identity.x509
cp -f /boot/activation/signing.x509 /etc/platform/sys/signing.x509

chmod 444 /etc/platform/sys/identity.x509 /etc/platform/sys/signing.x509
chattr +i /etc/platform/sys/identity.x509
chattr +i /etc/platform/sys/signing.x509


umount "${ROMFSMNT}" && rm -rf "${ROMFSMNT}" && sync
printf "Success\nPlease reboot terminal\n"
exit 0
fi

printf "Failed\n"
exit 1

