// MQX UI wrapper
;
(function (window, document, $) {
    var logfn;
    if (typeof log !== 'undefined' && log.error) {
        logfn = log.error;
    } else if (typeof console !== 'undefined' && console.log) {
        logfn = console.log;
    } else {
        throw {
            message: "$MQX library error: logging is not available"
        };
    }

    if (typeof window.$MQX !== 'undefined') {
        logfn("failed to initialize $MQX library: already defined");
        return;
    } else if (typeof $ === 'undefined') {
        logfn("error: $MQX library requires jQuery");
        return;
    }

    var cancelFn = [];
    window.$MQX = {
        cancel: function (fn) {
            cancelFn.push(fn);
        },

        restartUI: function () {
            if (window.$MQX.lastTimeout) {
                clearTimeout(window.$MQX.lastTimeout);
                window.$MQX.lastTimeout = 0;
            }

            window.$MQX.lastTimeout = setTimeout(function () {
                try {
                    $MQX.start();
                    window.$MQX.lastTimeout = 0;
                } catch (e) {
                    logfn('failed to restart secure input: ' + e.message);
                    //window.$MQX.restartUI();
                }
            }, 50);
        },

        start: function () {
            var buttons = $('.eqp-button:visible');
            if (!buttons.length) {
                return;
            }

            var mqxbtn = function (e) {
                var elem = $(e);
                var offs = elem.offset();
                if (!offs) {
                    throw {
                        message: "failed to get element offset"
                    }
                };
                var name = (offs.left) + ':' + (offs.top);
                if (!e.id) {
                    throw {
                        message: "failed to get element ID"
                    }
                };
                if (e.id.length > 14) {
                    throw {
                        message: "element ID is too long: " + e.id
                    }
                };
                var text = '#' + e.id;

                if (offs.left < 0 || offs.top < 0 || elem.outerWidth() < 5 || elem.outerHeight() < 5) {
                    throw {
                        message: "invalid element offset (" + e.id + ")"
                    };
                }

                var res = secure.promptButton(name, text, offs.left, offs.top,
                    elem.outerWidth(), elem.outerHeight(), '');
                if (res) {
                    throw {
                        message: "promptButton failed (result code " + res + ")"
                    };
                }
            };
            secure.promptClear();
            buttons.each(function () {
                mqxbtn(this);
            });

            var res = secure.promptEvent(-1);
            if (res && res.status) {
                throw {
                    message: "secure.promptStart failed with ( status " + res.status + ")"
                };
            }
        },

        beep: function () {
            tools.beep(1,5000,17,0);
        },

        attach: function () {
                secure.onSecureInput.connect(function (data) {
                    if (typeof data == 'undefined') {
                        data = [];
                    }

                    try {
                        for (var i in data) {
                            // physical cancel button
                            if (i == 'button' && data[i] == 'cancel') {
                                if (!cancelFn.length) {
                                    break;
                                }

                                for (var i in cancelFn) {
                                    try {
                                        cancelFn[i]();
                                    } catch (e) {
                                        logfn('invalid cancel function: ' + e.message);
                                    }
                                }
                                break;
                            }

                            // editbox text entered ?
                            if ($('#' + i).hasClass('edit-box')) {
                                $('#' + i).val(data[i]);
                                $('#' + i).trigger('change');
                                break;
                            }

                            var e = $(data[i] + ':visible');
                            if (!e.length) {
                                //logfn("no visible buttons found");
                            }
                            // show edit box ?
                            var chld = e.find('.edit-box');
                            if (chld.length) {
                                $MQX.createTextBox(chld[0]);
                                return;
                            }

                            // inputs
                            var inputs = e.find('input');
                            if (inputs.length) {
                                e = inputs[0];
                            }

                            $(e).click();
                        } // for

                        window.$MQX.restartUI();
                    } catch (e) {
                        var msg = 'failed to create secure input control: ' + e.message;
                        logfn(msg);
                        window.$gui && $gui.alert("error", msg);
                    }
                });
            } // attach : function
    }; // window.$MQX

    $(document).ready(function () {
        try {
            $MQX.attach();
            $MQX.start();
            //logfn( '$MQX initialized successfully' );
        } catch (e) {
            logfn('$MQX initialization failed: ' + e.message);
        }
    });
}(window, document, jQuery));
