;(function ( $, $MQX, window, document, undefined ) {
    if ( $.fn[pluginName] ) {
        return;
    }

    var pluginName = 'eqpscroll',
        defaults = {
            scrollDistance : 80
        };

    function Plugin( element, options ) {
        if ( ! element ) {
            throw { message: "invalid element (must be non null)" };
        }

        this.element = element;
        this.options = options ?  $.extend( {}, defaults, options) : defaults;

        this._defaults = defaults;
        this._name = pluginName;
        this.init();
    }

    Plugin.prototype.init = function () {
        var elementOverflows = this.element.clientHeight != this.element.scrollHeight;
        if ( ! elementOverflows ) {
            return;
        }

        var e = $("body");
        e.append("<span id='eqpscroollup' class='eqpscroll eqpscrolltop eqp-button'></span>");
        e.append("<span id='eqpscrooldown' class='eqpscroll eqpscrollbot eqp-button'></span>");

        var pluginElement = $(this.element);
        var distance = this.options.scrollDistance;
        $('#eqpscroollup').click(function () {
            try {
                var e = pluginElement;
                e.scrollTop(e.scrollTop() - distance);
            } catch (e) {
                console.log('scroll up failed: ' + e.message);
            }
        });

        $('#eqpscrooldown').click(function () {
            try {
                var e = pluginElement;
                e.scrollTop(e.scrollTop() + distance);
            } catch (e) {
                console.log('scroll down failed: ' + e.message);
            }
        });

        $MQX.restartUI();
    };

    // prevent multiple instances
    $.fn[pluginName] = function ( options ) {
        return this.each(function () {
            if (!$.data(this, 'plugin_' + pluginName)) {
                $.data(this, 'plugin_' + pluginName,
                new Plugin( this, options ));
            }
        });
    };
})( jQuery, $MQX, window, document );
