//--XXXXboundary action script
function onButtonUp() {
    if (ProductIdx > 0) {
        ProductIdx -= 1;
        updateSLB();
    }
    
}
//--XXXXboundary action script
function onButtonDown() {

    if (ProductIdx < (slbList.length  - 1)) {
        ProductIdx += 1;
 //       variableSet("DnBtnOn", "1");
        updateSLB();
    }


}
//--XXXXboundary action script
function processSLBUpdate(data) {

    var $xml;
    
    try {
        var xmlDoc = $.parseXML(data);      //parse string into XML document
        $xml = $(xmlDoc);                   //convert XML document into jQuery object
    } catch (e) {
        console.error("processSLBUpdate:, error parsing received data,  data: " + data + ", exception message: " + e.message);
        return;
    }

    var $slbItem = $xml.find("slb_item");

    //process slb_item's 
    if ($slbItem.length > 0) {
        $slbItem.each(function () {
            var slbItem = $(this);

            var description = slbItem.find("description").text();
            var qty = slbItem.find("qty").text();
            var price = slbItem.find("price").text();

            slbList.push({description: description, qty: qty, price: price});
            ProductIdx = slbList.length - 1;
        });

        //persist product list 
        variableSet("slb.ListJSON", JSON.stringify(slbList));
    }

    //process slb_clear command, if exist
    var $slbClear = $xml.find("slb_clear");
    if ($slbClear.length == 1) {

        //clear all
        slbList = [];
        variableSet("slb.ListJSON", JSON.stringify([]));
        
        //reset totals
        variableSet("slb.subtotal", "");
        variableSet("slb.tax", "");
        variableSet("slb.discount", "");
        variableSet("slb.total", "");
    }
    
    //process slb_total command, if exist
    var $slbTotal = $xml.find("slb_total");
    if ($slbTotal.length == 1) {


        var $subtotal = $slbTotal.find("subtotal");
        if($subtotal.length == 1) {
            variableSet("slb.subtotal", $subtotal.text());
        }
        var $tax = $slbTotal.find("tax");
        if($tax.length == 1) {
            variableSet("slb.tax", $tax.text());
        }
        $discount = $slbTotal.find("discount");
        if($discount.length == 1) {
            variableSet("slb.discount", $discount.text());
        }
        $total = $slbTotal.find("total");
        if($total.length == 1) {
            variableSet("slb.total", $total.text());
        }
    }

    //update view
    updateSLB();
}
//--XXXXboundary action script
function initializeSLBView() {

    slbList = [];

    var slbListJSON = variableGet("slb.ListJSON");
    if(slbListJSON) {
        try {
            slbList = JSON.parse(slbListJSON);
            ProductIdx = slbList.length - 1;
        } catch(e) { 
        }
    }
    
    var subtotal = variableGet("slb.subtotal");
    if(subtotal) {
        $(".slb-subtotal-value").text(subtotal);
    }

    var tax = variableGet("slb.tax");
    if(tax) {
        $(".slb-tax-value").text(tax);
    }

    var discount = variableGet("slb.discount");
    if(discount) {
        $(".slb-discount-value").text(discount);
    }

    var total = variableGet("slb.total");
    if(total) {
        $(".slb-total-value").text(total);
    }
    
    registerForVariable("slb.subtotal", function(oldVar, newVar) {
        $(".slb-subtotal-value").text(newVar);
    });

    registerForVariable("slb.tax", function(oldVar, newVar) {
        $(".slb-tax-value").text(newVar);
    });

    registerForVariable("slb.discount", function(oldVar, newVar) {
        $(".slb-discount-value").text(newVar);
    });

    registerForVariable("slb.total", function(oldVar, newVar) {
        $(".slb-total-value").text(newVar);
    });
    
    updateSLB();
}
//--XXXXboundary action script
function updateSLB() {
   
    var idx;
    var $tr;
    
    //clear slb table
    for(idx = 0 ; idx < slbVisibleItems ; idx++ ) {
        $tr = $("#slb-" + idx);
        $tr.find(".slb-id").html("&nbsp;");   //need to keep line height constant
        $tr.find(".slb-descr").text("");
        $tr.find(".slb-qty").text("");
        $tr.find(".slb-price").text("");
        if(idx === 0) {
            $tr.css("background-color", "");
        }
    }
    
    for(idx = 0 ; (idx < slbVisibleItems) && (idx <= ProductIdx) && (idx < slbList.length) ; idx++ ) {
        var pIdx = ProductIdx - idx;
        var item = slbList[pIdx];
        
        $tr = $("#slb-" + idx);
        
        $tr.find(".slb-id").text(pIdx + 1);
        $tr.find(".slb-descr").text(item.description);
        $tr.find(".slb-qty").text(item.qty);
        $tr.find(".slb-price").text(item.price);
        
        if(idx===0) {
            $tr.css("background-color", "#ffff00");
        }
    }
    
    variableSet("ListIndex",ProductIdx);
    
    if (slbList.length == 0) {
      variableSet("ListUpOn","0");
      variableSet("ListDnOn","0");
      return;  
    }
	
    if (ProductIdx == 0) {
      variableSet("ListUpOn","0");
    }
    else {
      variableSet("ListUpOn","1");
    }

    if (ProductIdx == slbList.length -1) {
      variableSet("ListDnOn","0");
    }
    else {
      variableSet("ListDnOn","1");
    }
        

}
//--XXXXboundary action script
function loadMenuList() {
   XMenuStr = variableGet("MenuList");
   clearMenuBtns();
   
   if (XMenuStr === undefined || XMenuStr === null || XMenuStr === "") {
      XMenuList = [];  // Clears XMenuStr
      return;
   }
  
   XMenuList = XMenuStr.split(",");
   XMaxMenuPtr = (XMenuList.length -1);
   displayMenuBtns();
}
//--XXXXboundary action script
function menuUpBtn() {
   if (XMenuPtr < 4) { 
      XMenuPtr = 0; }       
   else { 
      XMenuPtr -= 5; }
   
   displayMenuBtns();
}
//--XXXXboundary action script
function menuDnBtn() {
   if (XMaxMenuPtr < 5) {
      XMenuPtr = 0;
      displayMenuBtns();
      return;
   }
      
   if (XMenuPtr > (XMaxMenuPtr -5)) { 
      XMenuPtr = 0; }       
   else { 
      XMenuPtr += 5; }
      
   displayMenuBtns();
}
//--XXXXboundary action script
function displayMenuBtns() {
   var y = 0;
   var z = 0;
   var Name = "";
   var Val = "";
   
   clearMenuBtns();
   
   for (var x = 0; x < 5; x++) {
      y = x +1;
      z = XMenuPtr + x;
      
      if (y > XMaxMenuPtr) { 
        return; }
        
      Name = "menu" +y;
      Val = XMenuList[z];
      
      variableSet (Name, Val);
   }
   
   hideUpDn();
}
//--XXXXboundary action script
function clearMenuBtns() {
   for (var x = 1; x < 6; x++) {
      variableSet ("menu" +x, "");
   }
}
//--XXXXboundary action script
function initMenuBtns() {
  if (variableGet("MenuList") != null) {   
     loadMenuList();  
  }
}
//--XXXXboundary action script
function calcEventText(menuNum) {
  var X = 0;
  var Txt = "";
  var MenuText = "";
  
  X = XMenuPtr + parseInt(menuNum,10);
  MenuText = variableGet("menu" +menuNum);
  Txt = X.toString() + "=" +MenuText;
  fireEvent(Txt);
}
//--XXXXboundary action script
function hideUpDn() {
   if (XMenuPtr > 4) {
     variableSet("PrevOn", "1"); 
   }    
   else {      
     variableSet("PrevOn", "0"); }

   if (XMaxMenuPtr > (XMenuPtr +4)) {
      variableSet("NextOn", "1"); 
   }
   else {      
      variableSet("NextOn", "0"); }
}
//--XXXXboundary action script
function revealElement( id )
{
    document.getElementById( id ).style.visibility = "visible";
}
//--XXXXboundary action script
function initReg() {
   var newVar;
   newVar =  variableGet("ListClear");
   if (newVar == 1) {
      slbList = [];
      variableSet("slb.ListJSON", JSON.stringify([]));
    
      variableSet("slb.subtotal", "");
      variableSet("slb.tax", "");
      variableSet("slb.discount", "");
      variableSet("slb.total", "");
	
      variableSet("ListClear","0");
      
      updateSLB();
    }

}
//--XXXXboundary action script
function displayPromptNum() {
  var elem;
  var PromptNum = variableGet("PromptNum");
  var Val = parseInt(PromptNum,10);
   
  for (var x=1; x<10; x++) {
    PromptStr = "PROMPT" + x;
    elem = document.getElementsByClassName(PromptStr);

    if (x == Val) {
      elem[0].style.left = "0px";
    }
    else {
      elem[0].style.left = "1000px";
    }
  }   
}
//--XXXXboundary action script
function cancelFromKeypad( keyCode ) {
	if ( keyCode == 27 ) {
        fireEvent( "Cancel" );
    }
}
//--XXXXboundary action script
function clearFromKeypad( keyCode ) {
	if ( keyCode == 8 ) {
        fireEvent( "Clear" );
    }
}
//--XXXXboundary action script
function confirmFromKeypad( keyCode ) {
	if ( keyCode == 13 ) {
        fireEvent( "Enter" );
    }
}
//--XXXXboundary action script
function keypadKey(key) {
  if (key == 27) {
    fireEvent("Cancel");
  }
  else if (key == 8) {
    fireEvent("Clear");
  }
  else if (key == 13) {
    fireEvent("Enter");
  }
}
//--XXXXboundary action script
