(function ($) {
    window.descriptor = window.descriptor || {};
    var descriptorPrivate = {};

    window.descriptor = {
        load: function (path, cb, doneCb) {
            descriptorPrivate.load(path, cb, doneCb);
        },

        next: function (cb) {
            descriptorPrivate.next(cb);
        },

        previous: function (cb) {
            descriptorPrivate.previous(cb);
        },

        back: function (cb) {
            descriptorPrivate.back(cb);
        },

        pageCount: function () {
            return descriptorPrivate.pageCount();
        }
    };

    // implementation
    var descriptorPrivate = {
        menuItems: null,
        page: 0,
        itemsPerPage: 5
    };

    descriptorPrivate.pageCount = function () {
        if (!descriptorPrivate.menuItems) {
            return 0;
        }

        return Math.ceil(descriptorPrivate.menuItems.length / descriptorPrivate.itemsPerPage);
    };

    descriptorPrivate.load = function (path, cb, done) {
        $.get(path, function (data) {
                descriptorPrivate.menuItems = [];
                for (var i in data) {
                    var item = new MenuItem(data[i]);
                    if (item.OptionalEnabled(item)) {
                        descriptorPrivate.menuItems.push(item);
                    }
                }

                descriptorPrivate.menuItems
                    .sort(function (a, b) {
                        return a.icon_position - b.icon_position;
                    });

                cb(descriptorPrivate.menuItems.slice(0, descriptorPrivate.itemsPerPage));

                if (done) {
                    done();
                }
            }, "json")
            .fail(function (jqXHR, textStatus, errorThrown) {
                console.log("failed to load menu items, status: '" + textStatus + "'");
            });
    };

    descriptorPrivate.next = function (cb) {
        descriptorPrivate.page++;
        if (descriptorPrivate.page > descriptorPrivate.pageCount() - 1) {
            descriptorPrivate.page = 0;
        }

        var start = descriptorPrivate.itemsPerPage * descriptorPrivate.page;
        cb(descriptorPrivate.menuItems.slice(
            start,
            start + descriptorPrivate.itemsPerPage));
    };

    descriptorPrivate.previous = function (cb) {
        descriptorPrivate.page--;
        if (descriptorPrivate.page < 0) {
            descriptorPrivate.page = descriptorPrivate.pageCount() - 1;
        }

        var start = descriptorPrivate.itemsPerPage * descriptorPrivate.page;
        cb(descriptorPrivate.menuItems.slice(
            start,
            start + descriptorPrivate.itemsPerPage));
    };

    descriptorPrivate.back = function (cb) {
        descriptorPrivate.page--;
        if (descriptorPrivate.page < 0) {
            descriptorPrivate.page = 0;
        }

        var start = descriptorPrivate.itemsPerPage * descriptorPrivate.page;
        cb(descriptorPrivate.menuItems.slice(
            start,
            start + descriptorPrivate.itemsPerPage));
    };
})($);