;(function($){
    window.systemutils = window.systemutils || {};

    var keysImpl = {},
        infoImp = {},
        rkiImpl = {},
        networkInfoImpl = {},
        controllersImpl = {};

    window.systemutils.rki = {
        // args.config = { rki_host : string , rki_port : int, rki_cn : string }
        // args.success = function()
        // args.fail = function(msg)
        inject : function(args) {
            rkiImpl.inject(args);
        },

        getHost : function() {
            return rkiImpl.getHost();
        },

        getPort : function() {
            return rkiImpl.getPort();
        },

        getCN : function() {
            return rkiImpl.getCN();
        }
    };

    // sets network ino changed callback
    // cb = function(networkInfoArray)
    window.systemutils.network = {
        networkChanged : function(cb) {
            networkInfoImpl.networkChanged(cb);
        },

        getInfo : function() {
            return networkInfoImpl.readNetIfInfo();
        }
    };

    window.systemutils.info = {
        // args.success = function(terminalInfo {})
        // args.fail = function(msg)
        terminalInfo: function(args) {
            infoImp.terminalInfo(args);
        },

        // args.success = function(sysinfo)
        // args.fail = function(msg)
        getSysInfo: function (args) {
            infoImp.getSysInfo(args);
        },

        getVersionInfo: function(args) {
            infoImp.getVersionInfo(args);
        }
    };

    window.systemutils.keys = {
        // args.success = function(keys)
        // args.fail = function(msg)
        getInjectedKeys: function(args) {
            keysImpl.getInjectedKeys(args);
        }
    };
    window.systemutils.controllers = {

        // args.success = function(keys)
        // args.fail = function(msg)
        getControllers : function(args) {
            controllersImpl.getControllers(args);
        }
    };

    ////////////////////////////////////////////////////////////////////////////
    //  IMPL
    ////////////////////////////////////////////////////////////////////////////

    // rkiImpl
    (function(){
        rkiImpl.getHost = function() {
            return registry.getValue(settings.appName + ".rki.host") || "";
        };

        rkiImpl.getPort = function() {
            return registry.getValue(settings.appName + ".rki.port") || "";
        };

        rkiImpl.getCN = function() {
            return registry.getValue(settings.appName + ".rki.cn") || "";
        };

        rkiImpl.inject = function(args) {
            var queryString = '&host=' + args.config.rki_host +
                              '&port=' + args.config.rki_port +
                              '&cert=' + args.config.rki_cn +
                              '&timeout=60';
            //var queryString = '&host=162.223.154.172&port=2000&cert=SHA-2_Test_FutureX_CA_120215&timeout=15';
            $.ajax({
                type: "GET",
                url: '/cgi-bin/platform/key?function=remote' + queryString,
                success: function (data, status, xhr) {
                    try {
                        var $xml = $(data);
                        var statusCode = $xml.find("result").text();

                        if (statusCode !== '0') {
                            var errorMsg = $xml.find("text").text() || "RKI failed (unknown error)";
                            args.fail(errorMsg);
                            return;
                        }

                        registry.setValue(settings.appName + ".rki.host", args.config.rki_host);
                        registry.setValue(settings.appName + ".rki.port", args.config.rki_port);
                        registry.setValue(settings.appName + ".rki.cn",   args.config.rki_cn);

                        args.success();
                    } catch(e){
                        args.fail(e.message);
                    }

                },
                error: function (err) {
                    args.fail("RKI failed (HTTP error)");
                }
            });
        };
    })();

    // networkInfoImpl
    (function(){
        networkInfoImpl.netSettings = [];

        networkInfoImpl.networkChanged = function(cb) {
            networkInfoImpl.cb = cb;
        };

        networkInfoImpl.readNetIfInfo = function() {
            var netkeys = registry.getKeys("network.*.tcp.*");
            var interfaces = [];
            for (var i = 0; i < netkeys.length; ++i) {
                var netgroup = netkeys[i].match(/^network.([a-z0-9]*).*/);
                if (netgroup && netgroup.length >= 1) {
                    if (interfaces.indexOf(netgroup[1]) == -1 && netgroup[1] != "lo") {
                        interfaces.push(netgroup[1]);
                    }
                }
            }

            interfaces.sort();
            networkInfoImpl.netSettings = [];
            for (var i = 0; i < interfaces.length; ++i) {
                var ip      = registry.getValue("network." + interfaces[i] + ".tcp.ip");
                var mask    = registry.getValue("network." + interfaces[i] + ".tcp.mask");
                var hw      = registry.getValue("network." + interfaces[i] + ".tcp.mac");
                var running = registry.getValue("network." + interfaces[i] + ".tcp.running");
                var up      = " Down";

                if( running == "1" ) {
                    up = " Up";
                }

                var ip2Cidr = function(mask) {
                    var cidr = null;
                    if( mask ) {
                    var maskNodes = mask.match(/(\d+)/g);
                    if( maskNodes ) {
                    for (var i in maskNodes) {
                        cidr += (((maskNodes[i] >>> 0).toString(2)).match(/1/g) || []).length;
                    }
                    } }
                    return cidr;
                };
                networkInfoImpl.netSettings.push(" " + interfaces[i] + ": ip=" + ip + "/" + ip2Cidr(mask) + " hw=" + hw + up );
            } // for

            return networkInfoImpl.netSettings;
        }

        var changeHandler = function() {
            // Do not call registry from signal handler -> add re-read to event loop
            setTimeout( function(){
                var info = networkInfoImpl.readNetIfInfo();
                if ( networkInfoImpl.cb ) {
                    networkInfoImpl.cb(info);
                }
            }, 1000);
        };

        registry.valueChanged.connect(function(u1,u2){
            changeHandler();
        });
        registry.keyDeleted.connect(function(u1){
            changeHandler();
        });
        registry.subscribe("network.*");

        networkInfoImpl.readNetIfInfo();
    })();

    // infoImpl
    (function(){
        infoImp.terminalInfo = function(args) {
            $.get("/cgi-bin/platform/sysinfo?short_list", function (data) {
                args.success(data);
            });
        };

        infoImp.getVersionInfo = function(args){
            var xhttp = new XMLHttpRequest();
            xhttp.onreadystatechange = function () {
                try {
                    if (this.readyState == this.DONE && this.status == 200) {
                        if (this.responseText && this.responseText.length) {
                            args.success(this.responseText);
                        } else {
                            args.fail('http error');
                        }
                    } // if
                } catch (e) {
                    args.fail(e.message);
                }
            };
            var url = "/html/platform/version_info.html";
            xhttp.open("GET", url, true);
            xhttp.send();
        };

        infoImp.getSysInfo = function(args) {
            var xhttp = new XMLHttpRequest();
            xhttp.onreadystatechange = function () {
                try {
                    if (this.readyState == this.DONE && this.status == 200) {
                        if (this.responseText && this.responseText.length) {
                            args.success(JSON.parse(this.responseText));
                        } else {
                            args.fail('unknown error');
                        }
                    } // if
                } catch (e) {
                    args.fail(e.message);
                }
            };
            xhttp.open("GET", "/cgi-bin/platform/sysinfo", true);
            xhttp.send();
        };
    })();

    // keysImpl
    (function(){

        keysImpl.getInjectedKeys = function(args) {
            var xhttp = new XMLHttpRequest();
            xhttp.onreadystatechange = function() {
                if( this.readyState == 4 && this.status == 200 ) {
                    try {
                        var data = JSON.parse( this.responseText );
                        if ( 0 == data.result ) {
                            args.success(data);
                        } else {
                            args.fail("error code " + data.result + ". " + ( data.message ? data.message : "") );
                        }
                    }
                    catch(e) {
                        args.fail(e.message);
                    }
                }
            };

            xhttp.open( "GET", "/cgi-bin/platform/key", true );
            xhttp.setRequestHeader('accept', 'application/json');
            xhttp.send();
        };
    })();
    // controllersImpl
    (function(){
        controllersImpl.getControllers = function(args) {
            var xhttp = new XMLHttpRequest();
            xhttp.onreadystatechange = function() {
                if( this.readyState == 4 && this.status == 200 ) {
                    try {
                        var data = JSON.parse( this.responseText );
                        args.success(data);
                    }
                    catch(e) {
                        args.fail(e.message);
                    }

                }
            };
            xhttp.open( "GET", "/cgi-bin/platform/certificates", true );
            xhttp.setRequestHeader('accept', 'application/json');
            xhttp.send();
        };
    })();
})(jQuery);
